/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.walkthrough.common.source;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.annotation.Public;
import org.apache.flink.streaming.api.functions.source.FromIteratorFunction;
import org.apache.flink.walkthrough.common.entity.Transaction;
import org.apache.flink.walkthrough.common.source.TransactionIterator;

@Public
public class TransactionSource
extends FromIteratorFunction<Transaction> {
    private static final long serialVersionUID = 1L;

    public TransactionSource() {
        super(new RateLimitedIterator(TransactionIterator.unbounded()));
    }

    private static class RateLimitedIterator<T>
    implements Iterator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Iterator<T> inner;

        private RateLimitedIterator(Iterator<T> inner) {
            this.inner = inner;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public T next() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.inner.next();
        }
    }
}

