/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.executor;

import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestExecutorExtension<T extends ExecutorService>
implements BeforeAllCallback,
AfterAllCallback {
    private final Supplier<T> serviceFactory;
    private T executorService;

    public TestExecutorExtension(Supplier<T> serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.executorService = (ExecutorService)this.serviceFactory.get();
    }

    public T getExecutor() {
        return this.executorService;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

