/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate.window.combines;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.operators.deduplicate.utils.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.operators.window.tvf.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.tvf.state.StateKeyContext;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowState;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowValueState;
import org.apache.flink.table.runtime.util.WindowKey;

public final class RowTimeDeduplicateRecordsCombiner
implements RecordsCombiner {
    private final WindowTimerService<Long> timerService;
    private final StateKeyContext keyContext;
    private final WindowValueState<Long> dataState;
    private final int rowtimeIndex;
    private final boolean keepLastRow;
    private final TypeSerializer<RowData> recordSerializer;

    public RowTimeDeduplicateRecordsCombiner(WindowTimerService<Long> timerService, StateKeyContext keyContext, WindowValueState<Long> dataState, int rowtimeIndex, boolean keepLastRow, TypeSerializer<RowData> recordSerializer) {
        this.timerService = timerService;
        this.keyContext = keyContext;
        this.dataState = dataState;
        this.rowtimeIndex = rowtimeIndex;
        this.keepLastRow = keepLastRow;
        this.recordSerializer = recordSerializer;
    }

    @Override
    public void combine(WindowKey windowKey, Iterator<RowData> records) throws Exception {
        RowData bufferedResult = null;
        while (records.hasNext()) {
            RowData record = records.next();
            if (!RowDataUtil.isAccumulateMsg(record)) {
                throw new UnsupportedOperationException("Window deduplicate does not support input RowKind: " + record.getRowKind().shortString());
            }
            if (!DeduplicateFunctionHelper.shouldKeepCurrentRow(bufferedResult, record, this.rowtimeIndex, this.keepLastRow)) continue;
            bufferedResult = (RowData)this.recordSerializer.copy((Object)record);
        }
        if (bufferedResult == null) {
            return;
        }
        this.keyContext.setCurrentKey(windowKey.getKey());
        Long window = windowKey.getWindow();
        RowData preRow = this.dataState.value(window);
        if (DeduplicateFunctionHelper.shouldKeepCurrentRow(preRow, bufferedResult, this.rowtimeIndex, this.keepLastRow)) {
            this.dataState.update(window, bufferedResult);
        }
        this.timerService.registerEventTimeWindowTimer(window);
    }

    @Override
    public void close() throws Exception {
    }

    public static final class Factory
    implements RecordsCombiner.Factory {
        private static final long serialVersionUID = 1L;
        private final TypeSerializer<RowData> recordSerializer;
        private final int rowtimeIndex;
        private final boolean keepLastRow;

        public Factory(TypeSerializer<RowData> recordSerializer, int rowtimeIndex, boolean keepLastRow) {
            this.recordSerializer = recordSerializer;
            this.rowtimeIndex = rowtimeIndex;
            this.keepLastRow = keepLastRow;
        }

        @Override
        public RecordsCombiner createRecordsCombiner(RuntimeContext runtimeContext, WindowTimerService<Long> timerService, KeyedStateBackend<RowData> stateBackend, WindowState<Long> windowState, boolean isEventTime) throws Exception {
            WindowValueState windowMapState = (WindowValueState)windowState;
            return new RowTimeDeduplicateRecordsCombiner(timerService, arg_0 -> stateBackend.setCurrentKey(arg_0), windowMapState, this.rowtimeIndex, this.keepLastRow, this.recordSerializer);
        }
    }
}

