/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.CallSyntaxUtils;
import org.apache.flink.table.utils.EncodingUtils;

@Internal
public interface SqlCallSyntax {
    public static final SqlCallSyntax FUNCTION = new SqlCallSyntax(){

        @Override
        public String unparse(String sqlName, List<ResolvedExpression> operands) {
            return this.doUnParse(sqlName, operands, false);
        }

        @Override
        public String unparseDistinct(String sqlName, List<ResolvedExpression> operands) {
            return this.doUnParse(sqlName, operands, true);
        }

        private String doUnParse(String sqlName, List<ResolvedExpression> operands, boolean isDistinct) {
            return String.format("%s(%s%s)", sqlName, isDistinct ? "DISTINCT " : "", operands.stream().map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", ")));
        }
    };
    public static final SqlCallSyntax NO_PARENTHESIS = (sqlName, operands) -> sqlName;
    public static final SqlCallSyntax DISTINCT = (sqlName, operands) -> {
        CallExpression callExpression = (CallExpression)operands.get(0);
        if (callExpression.getFunctionDefinition() instanceof BuiltInFunctionDefinition) {
            BuiltInFunctionDefinition builtinDefinition = (BuiltInFunctionDefinition)callExpression.getFunctionDefinition();
            return builtinDefinition.getCallSyntax().unparseDistinct(builtinDefinition.getSqlName(), callExpression.getResolvedChildren());
        }
        return FUNCTION.unparseDistinct(callExpression.getFunctionName(), callExpression.getResolvedChildren());
    };
    public static final SqlCallSyntax COLLECTION_CTOR = (sqlName, operands) -> String.format("%s[%s]", sqlName, operands.stream().map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", ")));
    public static final SqlCallSyntax BINARY_OP = (sqlName, operands) -> String.format("%s %s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0)), sqlName, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(1)));
    public static final SqlCallSyntax MULTIPLE_BINARY_OP = (sqlName, operands) -> operands.stream().map(CallSyntaxUtils::asSerializableOperand).collect(Collectors.joining(String.format(" %s ", sqlName)));
    public static final SqlCallSyntax UNARY_SUFFIX_OP = (sqlName, operands) -> String.format("%s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0)), sqlName);
    public static final SqlCallSyntax UNARY_PREFIX_OP = (sqlName, operands) -> String.format("%s %s", sqlName, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0)));
    public static final SqlCallSyntax CAST = (sqlName, operands) -> String.format("%s(%s AS %s)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(), ((ResolvedExpression)operands.get(1)).asSerializableString());
    public static final SqlCallSyntax SUBSTRING = (sqlName, operands) -> {
        String s = String.format("%s(%s FROM %s", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(), ((ResolvedExpression)operands.get(1)).asSerializableString());
        if (operands.size() == 3) {
            return s + String.format(" FOR %s)", ((ResolvedExpression)operands.get(2)).asSerializableString());
        }
        return s + ")";
    };
    public static final SqlCallSyntax FLOOR_OR_CEIL = (sqlName, operands) -> {
        if (operands.size() == 1) {
            return FUNCTION.unparse(sqlName, operands);
        }
        return String.format("%s(%s TO %s)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(), ((ValueLiteralExpression)operands.get(1)).getValueAs(TimeIntervalUnit.class).get());
    };
    public static final SqlCallSyntax TRIM = (sqlName, operands) -> {
        boolean trimLeading = ((ValueLiteralExpression)operands.get(0)).getValueAs(Boolean.class).get();
        boolean trimTrailing = ((ValueLiteralExpression)operands.get(1)).getValueAs(Boolean.class).get();
        String format = trimLeading && trimTrailing ? "TRIM BOTH %s FROM %s" : (trimLeading ? "TRIM LEADING %s FROM %s" : (trimTrailing ? "TRIM TRAILING %s FROM %s" : "TRIM %s FROM %s"));
        return String.format(format, ((ResolvedExpression)operands.get(2)).asSerializableString(), ((ResolvedExpression)operands.get(3)).asSerializableString());
    };
    public static final SqlCallSyntax OVERLAY = (sqlName, operands) -> {
        String s = String.format("OVERLAY(%s PLACING %s FROM %s", ((ResolvedExpression)operands.get(0)).asSerializableString(), ((ResolvedExpression)operands.get(1)).asSerializableString(), ((ResolvedExpression)operands.get(2)).asSerializableString());
        if (operands.size() == 4) {
            return s + String.format(" FOR %s)", ((ResolvedExpression)operands.get(3)).asSerializableString());
        }
        return s + ")";
    };
    public static final SqlCallSyntax AS = (sqlName, operands) -> {
        if (operands.size() != 2) {
            throw new TableException("The AS function with multiple aliases is not SQL serializable. It should've been flattened during expression resolution.");
        }
        String identifier = ((ValueLiteralExpression)operands.get(1)).getValueAs(String.class).get();
        return String.format("%s %s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0)), sqlName, EncodingUtils.escapeIdentifier(identifier));
    };
    public static final SqlCallSyntax IN = (sqlName, operands) -> String.format("%s IN (%s)", ((ResolvedExpression)operands.get(0)).asSerializableString(), operands.subList(1, operands.size()).stream().map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", ")));
    public static final SqlCallSyntax WINDOW_START_END = (sqlName, operands) -> String.format("%s", sqlName);
    public static final SqlCallSyntax OVER = (sqlName, operands) -> {
        String projection = ((ResolvedExpression)operands.get(0)).asSerializableString();
        String order = ((ResolvedExpression)operands.get(1)).asSerializableString();
        String rangeBounds = CallSyntaxUtils.overRangeToSerializableString((ResolvedExpression)operands.get(2), (ResolvedExpression)operands.get(3));
        if (operands.size() == 4) {
            return String.format("%s OVER(ORDER BY %s %s)", projection, order, rangeBounds);
        }
        return String.format("%s OVER(PARTITION BY %s ORDER BY %s %s)", projection, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(4)), order, rangeBounds);
    };

    public String unparse(String var1, List<ResolvedExpression> var2);

    default public String unparseDistinct(String sqlName, List<ResolvedExpression> operands) {
        throw new UnsupportedOperationException("Only the FUNCTION syntax supports the DISTINCT clause.");
    }
}

