/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.operations.CalculatedQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
final class CalculatedTableFactory {
    CalculatedTableFactory() {
    }

    QueryOperation create(ResolvedExpression callExpr, List<String> leftTableFieldNames) {
        FunctionTableCallVisitor calculatedTableCreator = new FunctionTableCallVisitor(leftTableFieldNames);
        return (QueryOperation)callExpr.accept((ExpressionVisitor)calculatedTableCreator);
    }

    private static class FunctionTableCallVisitor
    extends ResolvedExpressionDefaultVisitor<CalculatedQueryOperation> {
        private final List<String> leftTableFieldNames;
        private static final String ATOMIC_FIELD_NAME = "f0";

        public FunctionTableCallVisitor(List<String> leftTableFieldNames) {
            this.leftTableFieldNames = leftTableFieldNames;
        }

        @Override
        public CalculatedQueryOperation visit(CallExpression call) {
            FunctionDefinition definition = call.getFunctionDefinition();
            if (definition.equals(BuiltInFunctionDefinitions.AS)) {
                return this.unwrapFromAlias(call);
            }
            return this.createFunctionCall(call, Collections.emptyList(), call.getResolvedChildren());
        }

        private CalculatedQueryOperation unwrapFromAlias(CallExpression call) {
            List children = call.getChildren();
            List<String> aliases = children.subList(1, children.size()).stream().map(alias -> (String)ExpressionUtils.extractValue((Expression)alias, String.class).orElseThrow(() -> new ValidationException("Unexpected alias: " + alias))).collect(Collectors.toList());
            if (!ApiExpressionUtils.isFunctionOfKind((Expression)children.get(0), FunctionKind.TABLE)) {
                throw this.fail();
            }
            CallExpression tableCall = (CallExpression)children.get(0);
            return this.createFunctionCall(tableCall, aliases, tableCall.getResolvedChildren());
        }

        private CalculatedQueryOperation createFunctionCall(CallExpression callExpression, List<String> aliases, List<ResolvedExpression> parameters) {
            ResolvedSchema resolvedSchema = this.adjustNames(this.extractSchema(callExpression.getOutputDataType()), aliases, callExpression.getFunctionName());
            return new CalculatedQueryOperation(ContextResolvedFunction.fromCallExpression(callExpression), parameters, resolvedSchema);
        }

        private ResolvedSchema extractSchema(DataType resultDataType) {
            if (LogicalTypeChecks.isCompositeType((LogicalType)resultDataType.getLogicalType())) {
                return DataTypeUtils.expandCompositeTypeToSchema((DataType)resultDataType);
            }
            int i = 0;
            Object fieldName = ATOMIC_FIELD_NAME;
            while (this.leftTableFieldNames.contains(fieldName)) {
                fieldName = "f0_" + i++;
            }
            return ResolvedSchema.physical(Collections.singletonList(fieldName), Collections.singletonList(resultDataType));
        }

        private ResolvedSchema adjustNames(ResolvedSchema resolvedSchema, List<String> aliases, String functionName) {
            int aliasesSize = aliases.size();
            if (aliasesSize == 0) {
                return resolvedSchema;
            }
            int callArity = resolvedSchema.getColumnCount();
            if (callArity != aliasesSize) {
                throw new ValidationException(String.format("List of column aliases must have same degree as table; the returned table of function '%s' has %d columns, whereas alias list has %d columns", functionName, callArity, aliasesSize));
            }
            return ResolvedSchema.physical(aliases, (List)resolvedSchema.getColumnDataTypes());
        }

        @Override
        protected CalculatedQueryOperation defaultMethod(ResolvedExpression expression) {
            throw this.fail();
        }

        private ValidationException fail() {
            return new ValidationException("A lateral join only accepts an expression which defines a table function call that might be followed by some alias.");
        }
    }
}

