/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public class ShowProceduresOperation
extends AbstractShowOperation {
    @Nullable
    private final String databaseName;

    public ShowProceduresOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        super(catalogName, preposition, likeOp);
        this.databaseName = databaseName;
    }

    public ShowProceduresOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        this(catalogName, databaseName, null, likeOp);
    }

    @Override
    protected Collection<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        CatalogManager catalogManager = ctx.getCatalogManager();
        String qualifiedCatalogName = catalogManager.qualifyCatalog(this.catalogName);
        String qualifiedDatabaseName = catalogManager.qualifyDatabase(this.databaseName);
        try {
            if (this.preposition == null) {
                return catalogManager.getCatalogOrError(qualifiedCatalogName).listProcedures(qualifiedDatabaseName);
            }
            Catalog catalog = catalogManager.getCatalogOrThrowException(qualifiedCatalogName);
            return catalog.listProcedures(qualifiedDatabaseName);
        }
        catch (DatabaseNotExistException e) {
            throw new TableException(String.format("Fail to show procedures because the Database `%s` to show from/in does not exist in Catalog `%s`.", qualifiedDatabaseName, qualifiedCatalogName), (Throwable)e);
        }
    }

    @Override
    protected String getOperationName() {
        return "SHOW PROCEDURES";
    }

    @Override
    protected String getColumnName() {
        return "procedure name";
    }

    @Override
    public String getPrepositionSummaryString() {
        if (this.databaseName == null) {
            return super.getPrepositionSummaryString();
        }
        return super.getPrepositionSummaryString() + "." + this.databaseName;
    }
}

