/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableOperation;

@Internal
public class AlterMaterializedTableRefreshOperation
extends AlterMaterializedTableOperation {
    private final Map<String, String> partitionSpec;

    public AlterMaterializedTableRefreshOperation(ObjectIdentifier tableIdentifier, Map<String, String> partitionSpec) {
        super(tableIdentifier);
        this.partitionSpec = partitionSpec;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        throw new UnsupportedOperationException("AlterMaterializedTableRefreshOperation does not support ExecutableOperation yet.");
    }

    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public String asSummaryString() {
        StringBuilder sb = new StringBuilder(String.format("ALTER MATERIALIZED TABLE %s REFRESH", this.tableIdentifier));
        if (!this.partitionSpec.isEmpty()) {
            sb.append(String.format(" PARTITION (%s)", OperationUtils.formatPartitionSpec(this.partitionSpec)));
        }
        return sb.toString();
    }
}

