/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ShowOperation;

@Internal
public class ShowPartitionsOperation
implements ShowOperation {
    protected final ObjectIdentifier tableIdentifier;
    @Nullable
    private final CatalogPartitionSpec partitionSpec;
    @Nullable
    private final String defaultPartitionName;

    public ShowPartitionsOperation(ObjectIdentifier tableIdentifier, @Nullable CatalogPartitionSpec partitionSpec) {
        this(tableIdentifier, partitionSpec, null);
    }

    public ShowPartitionsOperation(ObjectIdentifier tableIdentifier, @Nullable CatalogPartitionSpec partitionSpec, @Nullable String defaultPartitionName) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSpec = partitionSpec;
        this.defaultPartitionName = defaultPartitionName;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public CatalogPartitionSpec getPartitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("SHOW PARTITIONS %s", this.tableIdentifier.asSummaryString()));
        if (this.partitionSpec != null) {
            builder.append(String.format(" PARTITION (%s)", OperationUtils.formatPartitionSpec(this.partitionSpec)));
        }
        return builder.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ObjectPath tablePath = this.tableIdentifier.toObjectPath();
            Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.tableIdentifier.getCatalogName());
            List partitionSpecs = this.partitionSpec == null ? catalog.listPartitions(tablePath) : catalog.listPartitions(tablePath, this.partitionSpec);
            ArrayList<String> partitionNames = new ArrayList<String>(partitionSpecs.size());
            for (CatalogPartitionSpec spec : partitionSpecs) {
                ArrayList<String> partitionKVs = new ArrayList<String>(spec.getPartitionSpec().size());
                for (Map.Entry partitionKV : spec.getPartitionSpec().entrySet()) {
                    String partitionValue = partitionKV.getValue() == null ? this.defaultPartitionName : (String)partitionKV.getValue();
                    partitionKVs.add((String)partitionKV.getKey() + "=" + partitionValue);
                }
                partitionNames.add(String.join((CharSequence)"/", partitionKVs));
            }
            return TableResultUtils.buildStringArrayResult("partition name", partitionNames.toArray(new String[0]));
        }
        catch (TableNotExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

