/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class CalculatedQueryOperation
implements QueryOperation {
    private final ContextResolvedFunction resolvedFunction;
    private final List<ResolvedExpression> arguments;
    private final ResolvedSchema resolvedSchema;

    public CalculatedQueryOperation(ContextResolvedFunction resolvedFunction, List<ResolvedExpression> arguments, ResolvedSchema resolvedSchema) {
        this.resolvedFunction = resolvedFunction;
        this.arguments = arguments;
        this.resolvedSchema = resolvedSchema;
    }

    public ContextResolvedFunction getResolvedFunction() {
        return this.resolvedFunction;
    }

    public List<ResolvedExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("function", this.resolvedFunction);
        args.put("arguments", this.arguments);
        return OperationUtils.formatWithChildren("CalculatedTable", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("LATERAL TABLE(%s) T$0(%s)", this.resolvedFunction.toCallExpression(this.arguments, this.resolvedSchema.toPhysicalRowDataType()).asSerializableString(), OperationUtils.formatSelectColumns(this.resolvedSchema));
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <U> U accept(QueryOperationVisitor<U> visitor) {
        return visitor.visit(this);
    }
}

