/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;

@Internal
public class ProjectQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_PROJECT";
    private final List<ResolvedExpression> projectList;
    private final QueryOperation child;
    private final ResolvedSchema resolvedSchema;

    public ProjectQueryOperation(List<ResolvedExpression> projectList, QueryOperation child, ResolvedSchema resolvedSchema) {
        this.projectList = projectList;
        this.child = child;
        this.resolvedSchema = resolvedSchema;
    }

    public List<ResolvedExpression> getProjectList() {
        return this.projectList;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("projections", this.projectList);
        return OperationUtils.formatWithChildren("Project", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("SELECT %s FROM (%s\n) $$T_PROJECT", IntStream.range(0, this.projectList.size()).mapToObj(this::alias).map(expr -> OperationExpressionsUtils.scopeReferencesWithAlias(INPUT_ALIAS, expr)).map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", ")), OperationUtils.indent(this.child.asSerializableString()));
    }

    private ResolvedExpression alias(int index) {
        ResolvedExpression expression = this.projectList.get(index);
        String columnName = this.resolvedSchema.getColumnNames().get(index);
        if (OperationExpressionsUtils.extractName(expression).map(n -> n.equals(columnName)).orElse(false).booleanValue()) {
            return expression;
        }
        return CallExpression.permanent(BuiltInFunctionDefinitions.AS, Arrays.asList(expression, new ValueLiteralExpression(columnName)), expression.getOutputDataType());
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

