/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.StringUtils;

@Internal
public class OperationUtils {
    private static final String OPERATION_INDENT = "    ";

    static String indent(String item) {
        Pattern pattern = Pattern.compile("('([^']|'')*')|\\n");
        Matcher matcher = pattern.matcher(item);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group();
            if (group.startsWith("'")) {
                matcher.appendReplacement(output, Matcher.quoteReplacement(group));
                continue;
            }
            String replaced = group.replaceAll("\n", "\n    ");
            matcher.appendReplacement(output, Matcher.quoteReplacement(replaced));
        }
        matcher.appendTail(output);
        return "\n    " + output;
    }

    public static <T extends Operation> String formatWithChildren(String operationName, Map<String, Object> parameters, List<T> children, Function<T, String> childToString) {
        String description = parameters.entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(operationName).append(":");
        if (!StringUtils.isNullOrWhitespaceOnly((String)description)) {
            stringBuilder.append(" (").append(description).append(")");
        }
        String childrenDescription = children.stream().map(child -> OperationUtils.indent((String)childToString.apply(child))).collect(Collectors.joining());
        return stringBuilder.append(childrenDescription).toString();
    }

    public static String formatSelectColumns(ResolvedSchema schema, @Nullable String inputAlias) {
        return schema.getColumnNames().stream().map(i -> {
            if (inputAlias == null) {
                return EncodingUtils.escapeIdentifier(i);
            }
            return String.format("%s.%s", EncodingUtils.escapeIdentifier(inputAlias), EncodingUtils.escapeIdentifier(i));
        }).collect(Collectors.joining(", "));
    }

    public static String formatParameter(String name, Object value) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(name);
        stringBuilder.append(": ");
        if (value.getClass().isArray()) {
            stringBuilder.append(Arrays.toString((Object[])value));
        } else if (value instanceof Collection) {
            stringBuilder.append(value);
        } else {
            stringBuilder.append("[").append(value).append("]");
        }
        return stringBuilder.toString();
    }

    public static String formatProperties(Map<String, String> properties) {
        return properties.entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public static String formatPartitionSpec(CatalogPartitionSpec spec) {
        return OperationUtils.formatPartitionSpec(spec.getPartitionSpec());
    }

    public static String formatPartitionSpec(Map<String, String> spec) {
        return spec.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "));
    }

    private OperationUtils() {
    }
}

