/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.tsextractors;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Deprecated
@PublicEvolving
public final class ExistingField
extends TimestampExtractor {
    private static final long serialVersionUID = 1L;
    private String field;

    public ExistingField(String field) {
        this.field = (String)Preconditions.checkNotNull((Object)field);
    }

    @Override
    public String[] getArgumentFields() {
        return new String[]{this.field};
    }

    @Override
    public void validateArgumentFields(TypeInformation<?>[] argumentFieldTypes) {
        DataType fieldType = TypeConversions.fromLegacyInfoToDataType(argumentFieldTypes[0]);
        switch (fieldType.getLogicalType().getTypeRoot()) {
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case VARCHAR: {
                break;
            }
            default: {
                throw new ValidationException(String.format("Field '%s' must be of type Long or Timestamp or String but is of type %s.", this.field, fieldType));
            }
        }
    }

    @Override
    public Expression getExpression(ResolvedFieldReference[] fieldAccesses) {
        ResolvedFieldReference fieldAccess = fieldAccesses[0];
        DataType type = TypeConversions.fromLegacyInfoToDataType(fieldAccess.resultType());
        FieldReferenceExpression fieldReferenceExpr = new FieldReferenceExpression(fieldAccess.name(), type, 0, fieldAccess.fieldIndex());
        switch (type.getLogicalType().getTypeRoot()) {
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return fieldReferenceExpr;
            }
            case VARCHAR: {
                DataType outputType = (DataType)DataTypes.TIMESTAMP(3).bridgedTo(Timestamp.class);
                return CallExpression.permanent(BuiltInFunctionDefinitions.CAST, Arrays.asList(fieldReferenceExpr, ApiExpressionUtils.typeLiteral(outputType)), outputType);
            }
        }
        throw new RuntimeException("Unsupport type: " + type);
    }

    @Override
    public Map<String, String> toProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rowtime.timestamps.type", "from-field");
        map.put("rowtime.timestamps.from", this.field);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistingField that = (ExistingField)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

