/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.RowCsvInputFormat;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Deprecated
@Internal
public class CsvTableSource
implements StreamTableSource<Row>,
LookupableTableSource<Row>,
ProjectableTableSource<Row> {
    private final CsvInputFormatConfig config;

    public CsvTableSource(String path, String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        this(path, fieldNames, fieldTypes, IntStream.range(0, fieldNames.length).toArray(), ",", "\n", null, false, null, false);
    }

    public CsvTableSource(String path, String[] fieldNames, TypeInformation<?>[] fieldTypes, String fieldDelim, String lineDelim, Character quoteCharacter, boolean ignoreFirstLine, String ignoreComments, boolean lenient) {
        this(path, fieldNames, fieldTypes, IntStream.range(0, fieldNames.length).toArray(), fieldDelim, lineDelim, quoteCharacter, ignoreFirstLine, ignoreComments, lenient);
    }

    public CsvTableSource(String path, String[] fieldNames, TypeInformation<?>[] fieldTypes, int[] selectedFields, String fieldDelim, String lineDelim, Character quoteCharacter, boolean ignoreFirstLine, String ignoreComments, boolean lenient) {
        this(new CsvInputFormatConfig(path, fieldNames, TypeConversions.fromLegacyInfoToDataType(fieldTypes), selectedFields, fieldDelim, lineDelim, quoteCharacter, ignoreFirstLine, ignoreComments, lenient, false));
    }

    private CsvTableSource(CsvInputFormatConfig config) {
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DataType getProducedDataType() {
        return TableSchema.builder().fields(this.config.getSelectedFieldNames(), this.config.getSelectedFieldDataTypes()).build().toRowDataType();
    }

    private TypeInformation<Row> getProducedTypeInformation() {
        return TypeConversions.fromDataTypeToLegacyInfo((DataType)this.getProducedDataType());
    }

    public TableSchema getTableSchema() {
        return TableSchema.builder().fields(this.config.fieldNames, this.config.fieldTypes).build();
    }

    public CsvTableSource projectFields(int[] fields) {
        if (fields.length == 0) {
            fields = new int[]{};
        }
        return new CsvTableSource(this.config.select(fields));
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public DataStream<Row> getDataStream(StreamExecutionEnvironment execEnv) {
        return execEnv.createInput((InputFormat)this.config.createInputFormat(), this.getProducedTypeInformation()).name(this.explainSource());
    }

    public TableFunction<Row> getLookupFunction(String[] lookupKeys) {
        return new CsvLookupFunction(this.config, lookupKeys);
    }

    public AsyncTableFunction<Row> getAsyncLookupFunction(String[] lookupKeys) {
        throw new UnsupportedOperationException("CSV do not support async lookup");
    }

    public boolean isAsyncEnabled() {
        return false;
    }

    public String explainSource() {
        CharSequence[] fields = this.config.getSelectedFieldNames();
        return "CsvTableSource(read fields: " + String.join((CharSequence)", ", fields) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvTableSource that = (CsvTableSource)o;
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }

    private static class CsvInputFormatConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String path;
        private final String[] fieldNames;
        private final DataType[] fieldTypes;
        private final int[] selectedFields;
        private final String fieldDelim;
        private final String lineDelim;
        private final Character quoteCharacter;
        private final boolean ignoreFirstLine;
        private final String ignoreComments;
        private final boolean lenient;
        private final boolean emptyColumnAsNull;

        CsvInputFormatConfig(String path, String[] fieldNames, DataType[] fieldTypes, int[] selectedFields, String fieldDelim, String lineDelim, Character quoteCharacter, boolean ignoreFirstLine, String ignoreComments, boolean lenient, boolean emptyColumnAsNull) {
            this.path = path;
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.selectedFields = selectedFields;
            this.fieldDelim = fieldDelim;
            this.lineDelim = lineDelim;
            this.quoteCharacter = quoteCharacter;
            this.ignoreFirstLine = ignoreFirstLine;
            this.ignoreComments = ignoreComments;
            this.lenient = lenient;
            this.emptyColumnAsNull = emptyColumnAsNull;
        }

        String[] getSelectedFieldNames() {
            String[] selectedFieldNames = new String[this.selectedFields.length];
            for (int i = 0; i < this.selectedFields.length; ++i) {
                selectedFieldNames[i] = this.fieldNames[this.selectedFields[i]];
            }
            return selectedFieldNames;
        }

        DataType[] getSelectedFieldDataTypes() {
            DataType[] selectedFieldTypes = new DataType[this.selectedFields.length];
            for (int i = 0; i < this.selectedFields.length; ++i) {
                selectedFieldTypes[i] = this.fieldTypes[this.selectedFields[i]];
            }
            return selectedFieldTypes;
        }

        TypeInformation<?>[] getSelectedFieldTypes() {
            return (TypeInformation[])Arrays.stream(this.getSelectedFieldDataTypes()).map(TypeConversions::fromDataTypeToLegacyInfo).toArray(TypeInformation[]::new);
        }

        RowCsvInputFormat createInputFormat() {
            RowCsvInputFormat inputFormat = new RowCsvInputFormat(new Path(this.path), this.getSelectedFieldTypes(), this.lineDelim, this.fieldDelim, this.selectedFields, this.emptyColumnAsNull);
            inputFormat.setSkipFirstLineAsHeader(this.ignoreFirstLine);
            inputFormat.setCommentPrefix(this.ignoreComments);
            inputFormat.setLenient(this.lenient);
            if (this.quoteCharacter != null) {
                inputFormat.enableQuotedStringParsing(this.quoteCharacter.charValue());
            }
            return inputFormat;
        }

        CsvInputFormatConfig select(int[] fields) {
            return new CsvInputFormatConfig(this.path, this.fieldNames, this.fieldTypes, fields, this.fieldDelim, this.lineDelim, this.quoteCharacter, this.ignoreFirstLine, this.ignoreComments, this.lenient, this.emptyColumnAsNull);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CsvInputFormatConfig that = (CsvInputFormatConfig)o;
            return this.ignoreFirstLine == that.ignoreFirstLine && this.lenient == that.lenient && Objects.equals(this.path, that.path) && Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.fieldTypes, that.fieldTypes) && Arrays.equals(this.selectedFields, that.selectedFields) && Objects.equals(this.fieldDelim, that.fieldDelim) && Objects.equals(this.lineDelim, that.lineDelim) && Objects.equals(this.quoteCharacter, that.quoteCharacter) && Objects.equals(this.ignoreComments, that.ignoreComments) && Objects.equals(this.emptyColumnAsNull, that.emptyColumnAsNull);
        }

        public int hashCode() {
            int result = Objects.hash(this.path, this.fieldDelim, this.lineDelim, this.quoteCharacter, this.ignoreFirstLine, this.ignoreComments, this.lenient, this.emptyColumnAsNull);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            result = 31 * result + Arrays.hashCode(this.fieldTypes);
            result = 31 * result + Arrays.hashCode(this.selectedFields);
            return result;
        }
    }

    @Internal
    public static class CsvLookupFunction
    extends TableFunction<Row> {
        private static final long serialVersionUID = 1L;
        private final CsvInputFormatConfig config;
        private final List<Integer> sourceKeys = new ArrayList<Integer>();
        private final List<Integer> targetKeys = new ArrayList<Integer>();
        private final Map<Object, List<Row>> dataMap = new HashMap<Object, List<Row>>();

        CsvLookupFunction(CsvInputFormatConfig config, String[] lookupKeys) {
            this.config = config;
            List<String> fields = Arrays.asList(config.getSelectedFieldNames());
            for (int i = 0; i < lookupKeys.length; ++i) {
                this.sourceKeys.add(i);
                int targetIdx = fields.indexOf(lookupKeys[i]);
                assert (targetIdx != -1);
                this.targetKeys.add(targetIdx);
            }
        }

        public TypeInformation<Row> getResultType() {
            return new RowTypeInfo(this.config.getSelectedFieldTypes(), this.config.getSelectedFieldNames());
        }

        public void open(FunctionContext context) throws Exception {
            FileInputSplit[] inputSplits;
            super.open(context);
            TypeInformation<Row> rowType = this.getResultType();
            RowCsvInputFormat inputFormat = this.config.createInputFormat();
            for (FileInputSplit split : inputSplits = inputFormat.createInputSplits(1)) {
                Row r;
                inputFormat.open(split);
                Row row = new Row(rowType.getArity());
                while ((r = (Row)inputFormat.nextRecord((Object)row)) != null) {
                    Object key = this.getTargetKey(r);
                    List rows = this.dataMap.computeIfAbsent(key, k -> new ArrayList());
                    rows.add(Row.copy((Row)r));
                }
                inputFormat.close();
            }
        }

        public void eval(Object ... values) {
            Object srcKey = this.getSourceKey(Row.of((Object[])values));
            if (this.dataMap.containsKey(srcKey)) {
                for (Row row1 : this.dataMap.get(srcKey)) {
                    this.collect(row1);
                }
            }
        }

        private Object getSourceKey(Row source) {
            return this.getKey(source, this.sourceKeys);
        }

        private Object getTargetKey(Row target) {
            return this.getKey(target, this.targetKeys);
        }

        private Object getKey(Row input, List<Integer> keys) {
            if (keys.size() == 1) {
                int keyIdx = keys.get(0);
                if (input.getField(keyIdx) != null) {
                    return input.getField(keyIdx);
                }
                return null;
            }
            Row key = new Row(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                int keyIdx = keys.get(i);
                key.setField(i, input.getField(keyIdx));
            }
            return key;
        }

        public void close() throws Exception {
            super.close();
        }
    }

    @Internal
    public static class Builder {
        private LinkedHashMap<String, DataType> schema = new LinkedHashMap();
        private Character quoteCharacter;
        private String path;
        private String fieldDelim = ",";
        private String lineDelim = "\n";
        private boolean isIgnoreFirstLine = false;
        private String commentPrefix;
        private boolean lenient = false;
        private boolean emptyColumnAsNull = false;

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder fieldDelimiter(String delim) {
            this.fieldDelim = delim;
            return this;
        }

        public Builder lineDelimiter(String delim) {
            this.lineDelim = delim;
            return this;
        }

        public Builder field(String fieldName, DataType fieldType) {
            DataType type;
            if (this.schema.containsKey(fieldName)) {
                throw new IllegalArgumentException("Duplicate field name " + fieldName);
            }
            switch (fieldType.getLogicalType().getTypeRoot()) {
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    type = (DataType)fieldType.bridgedTo(Timestamp.class);
                    break;
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    type = (DataType)fieldType.bridgedTo(Time.class);
                    break;
                }
                case DATE: {
                    type = (DataType)fieldType.bridgedTo(Date.class);
                    break;
                }
                default: {
                    type = fieldType;
                }
            }
            this.schema.put(fieldName, type);
            return this;
        }

        @Deprecated
        public Builder field(String fieldName, TypeInformation<?> fieldType) {
            return this.field(fieldName, TypeConversions.fromLegacyInfoToDataType(fieldType));
        }

        public Builder quoteCharacter(Character quote) {
            this.quoteCharacter = quote;
            return this;
        }

        public Builder commentPrefix(String prefix) {
            this.commentPrefix = prefix;
            return this;
        }

        public Builder ignoreFirstLine() {
            this.isIgnoreFirstLine = true;
            return this;
        }

        public Builder ignoreParseErrors() {
            this.lenient = true;
            return this;
        }

        public Builder emptyColumnAsNull() {
            this.emptyColumnAsNull = true;
            return this;
        }

        public CsvTableSource build() {
            if (this.path == null) {
                throw new IllegalArgumentException("Path must be defined.");
            }
            if (this.schema.isEmpty()) {
                throw new IllegalArgumentException("Fields can not be empty.");
            }
            return new CsvTableSource(new CsvInputFormatConfig(this.path, this.schema.keySet().toArray(new String[0]), this.schema.values().toArray(new DataType[0]), IntStream.range(0, this.schema.values().size()).toArray(), this.fieldDelim, this.lineDelim, this.quoteCharacter, this.isIgnoreFirstLine, this.commentPrefix, this.lenient, this.emptyColumnAsNull));
        }
    }
}

