/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.async;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RichAsyncFunctionTest {
    RichAsyncFunctionTest() {
    }

    @Test
    void testIterationRuntimeContext() {
        RichAsyncFunction<Integer, Integer> function = new RichAsyncFunction<Integer, Integer>(){
            private static final long serialVersionUID = -2023923961609455894L;

            public void asyncInvoke(Integer input, ResultFuture<Integer> resultFuture) throws Exception {
            }
        };
        int superstepNumber = 42;
        IterationRuntimeContext mockedIterationRuntimeContext = (IterationRuntimeContext)Mockito.mock(IterationRuntimeContext.class);
        Mockito.when((Object)mockedIterationRuntimeContext.getSuperstepNumber()).thenReturn((Object)superstepNumber);
        function.setRuntimeContext((RuntimeContext)mockedIterationRuntimeContext);
        IterationRuntimeContext iterationRuntimeContext = function.getIterationRuntimeContext();
        Assertions.assertThat((int)iterationRuntimeContext.getSuperstepNumber()).isEqualTo(superstepNumber);
        Assertions.assertThatThrownBy(() -> iterationRuntimeContext.getIterationAggregator("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> iterationRuntimeContext.getPreviousIterationAggregate("foobar")).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testRuntimeContext() {
        RichAsyncFunction<Integer, Integer> function = new RichAsyncFunction<Integer, Integer>(){
            private static final long serialVersionUID = 1707630162838967972L;

            public void asyncInvoke(Integer input, ResultFuture<Integer> resultFuture) throws Exception {
            }
        };
        String taskName = "foobarTask";
        OperatorMetricGroup metricGroup = UnregisteredMetricsGroup.createOperatorMetricGroup();
        int numberOfParallelSubtasks = 43;
        int indexOfSubtask = 42;
        int attemptNumber = 1337;
        String taskNameWithSubtask = "foobarTask (43/43)#1337";
        HashMap<String, String> globalJobParameters = new HashMap<String, String>();
        globalJobParameters.put("k1", "v1");
        ClassLoader userCodeClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        boolean isObjectReused = true;
        RuntimeContext mockedRuntimeContext = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        TaskInfo mockedTaskInfo = (TaskInfo)Mockito.mock(TaskInfo.class);
        Mockito.when((Object)mockedTaskInfo.getTaskName()).thenReturn((Object)"foobarTask");
        Mockito.when((Object)mockedTaskInfo.getNumberOfParallelSubtasks()).thenReturn((Object)43);
        Mockito.when((Object)mockedTaskInfo.getIndexOfThisSubtask()).thenReturn((Object)42);
        Mockito.when((Object)mockedTaskInfo.getAttemptNumber()).thenReturn((Object)1337);
        Mockito.when((Object)mockedTaskInfo.getTaskNameWithSubtasks()).thenReturn((Object)"foobarTask (43/43)#1337");
        Mockito.when((Object)mockedRuntimeContext.getTaskInfo()).thenReturn((Object)mockedTaskInfo);
        Mockito.when((Object)mockedRuntimeContext.getMetricGroup()).thenReturn((Object)metricGroup);
        Mockito.when((Object)mockedRuntimeContext.getGlobalJobParameters()).thenReturn(globalJobParameters);
        Mockito.when((Object)mockedRuntimeContext.isObjectReuseEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockedRuntimeContext.getUserCodeClassLoader()).thenReturn((Object)userCodeClassLoader);
        function.setRuntimeContext(mockedRuntimeContext);
        RuntimeContext runtimeContext = function.getRuntimeContext();
        Assertions.assertThat((String)runtimeContext.getTaskInfo().getTaskName()).isEqualTo("foobarTask");
        Assertions.assertThat((Object)runtimeContext.getMetricGroup()).isEqualTo((Object)metricGroup);
        Assertions.assertThat((int)runtimeContext.getTaskInfo().getNumberOfParallelSubtasks()).isEqualTo(43);
        Assertions.assertThat((int)runtimeContext.getTaskInfo().getIndexOfThisSubtask()).isEqualTo(42);
        Assertions.assertThat((int)runtimeContext.getTaskInfo().getAttemptNumber()).isEqualTo(1337);
        Assertions.assertThat((String)runtimeContext.getTaskInfo().getTaskNameWithSubtasks()).isEqualTo("foobarTask (43/43)#1337");
        Assertions.assertThat((Map)runtimeContext.getGlobalJobParameters()).isEqualTo(globalJobParameters);
        Assertions.assertThat((boolean)runtimeContext.isObjectReuseEnabled()).isEqualTo(true);
        Assertions.assertThat((Object)runtimeContext.getUserCodeClassLoader()).isEqualTo((Object)userCodeClassLoader);
        Assertions.assertThatThrownBy(() -> ((RuntimeContext)runtimeContext).getDistributedCache()).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getState(new ValueStateDescriptor("foobar", Integer.class, (Object)42))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getListState(new org.apache.flink.api.common.state.ListStateDescriptor("foobar", Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getReducingState(new ReducingStateDescriptor("foobar", (ReduceFunction)new ReduceFunction<Integer>(){
            private static final long serialVersionUID = 2136425961884441050L;

            public Integer reduce(Integer value1, Integer value2) {
                return value1;
            }
        }, Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getAggregatingState(new org.apache.flink.api.common.state.AggregatingStateDescriptor("foobar", (AggregateFunction)new AggregateFunction<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return null;
            }

            public Integer add(Integer value, Integer accumulator) {
                return null;
            }

            public Integer getResult(Integer accumulator) {
                return null;
            }

            public Integer merge(Integer a, Integer b) {
                return null;
            }
        }, Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getMapState(new org.apache.flink.api.common.state.MapStateDescriptor("foobar", Integer.class, String.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getState(new org.apache.flink.api.common.state.v2.ValueStateDescriptor("foobar", Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getListState(new ListStateDescriptor("foobar", Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getReducingState(new org.apache.flink.api.common.state.v2.ReducingStateDescriptor("foobar", (ReduceFunction)new ReduceFunction<Integer>(){
            private static final long serialVersionUID = 2136425961884441050L;

            public Integer reduce(Integer value1, Integer value2) {
                return value1;
            }
        }, Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getAggregatingState(new AggregatingStateDescriptor("foobar", (AggregateFunction)new AggregateFunction<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return null;
            }

            public Integer add(Integer value, Integer accumulator) {
                return null;
            }

            public Integer getResult(Integer accumulator) {
                return null;
            }

            public Integer merge(Integer a, Integer b) {
                return null;
            }
        }, Integer.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getMapState(new MapStateDescriptor("foobar", Integer.class, String.class))).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.addAccumulator("foobar", (Accumulator)new Accumulator<Integer, Integer>(){
            private static final long serialVersionUID = -4673320336846482358L;

            public void add(Integer value) {
            }

            public Integer getLocalValue() {
                return null;
            }

            public void resetLocal() {
            }

            public void merge(Accumulator<Integer, Integer> other) {
            }

            public Accumulator<Integer, Integer> clone() {
                return null;
            }
        })).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getAccumulator("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getIntCounter("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getLongCounter("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getDoubleCounter("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getHistogram("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getBroadcastVariable("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.hasBroadcastVariable("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getBroadcastVariable("foobar")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> runtimeContext.getBroadcastVariableWithInitializer("foobar", data -> null)).isInstanceOf(UnsupportedOperationException.class);
    }
}

