/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.KeyContextHandler;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessing;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

@Experimental
public abstract class AbstractInput<IN, OUT>
implements Input<IN>,
KeyContextHandler,
AsyncStateProcessing {
    @Nullable
    protected final KeySelector<?, ?> stateKeySelector;
    protected final AbstractStreamOperatorV2<OUT> owner;
    protected final int inputId;
    protected final Output<StreamRecord<OUT>> output;

    public AbstractInput(AbstractStreamOperatorV2<OUT> owner, int inputId) {
        Preconditions.checkArgument((inputId > 0 ? 1 : 0) != 0, (Object)"Inputs are index from 1");
        this.owner = owner;
        this.inputId = inputId;
        this.stateKeySelector = owner.config.getStatePartitioner(inputId - 1, owner.getUserCodeClassloader());
        this.output = owner.output;
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.owner.reportWatermark(mark, this.inputId);
    }

    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        this.owner.reportOrForwardLatencyMarker(latencyMarker);
    }

    public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        this.owner.processWatermarkStatus(watermarkStatus, this.inputId);
    }

    public void setKeyContextElement(StreamRecord record) throws Exception {
        this.owner.internalSetKeyContextElement(record, this.stateKeySelector);
    }

    public void processRecordAttributes(RecordAttributes recordAttributes) throws Exception {
        this.owner.processRecordAttributes(recordAttributes, this.inputId);
    }

    public boolean hasKeyContext() {
        return this.stateKeySelector != null;
    }

    @Internal
    public final boolean isAsyncStateProcessingEnabled() {
        return this.owner instanceof AsyncStateProcessingOperator && ((AsyncStateProcessingOperator)this.owner).isAsyncStateProcessingEnabled();
    }

    @Internal
    public final ThrowingConsumer<StreamRecord<IN>, Exception> getRecordProcessor(int inputId) {
        return AsyncStateProcessing.makeRecordProcessor((AsyncStateProcessingOperator)((AsyncStateProcessingOperator)this.owner), this.stateKeySelector, arg_0 -> ((AbstractInput)this).processElement(arg_0));
    }
}

