/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.legacy;

import java.io.IOException;
import java.time.Clock;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class TwoPhaseCommitSinkFunction<IN, TXN, CONTEXT>
extends RichSinkFunction<IN>
implements CheckpointedFunction,
CheckpointListener {
    private static final Logger LOG = LoggerFactory.getLogger(TwoPhaseCommitSinkFunction.class);
    protected final LinkedHashMap<Long, TransactionHolder<TXN>> pendingCommitTransactions = new LinkedHashMap();
    protected transient Optional<CONTEXT> userContext;
    protected transient ListState<State<TXN, CONTEXT>> state;
    private final Clock clock;
    private final ListStateDescriptor<State<TXN, CONTEXT>> stateDescriptor;
    @Nullable
    private TransactionHolder<TXN> currentTransactionHolder;
    private long transactionTimeout = Long.MAX_VALUE;
    private boolean ignoreFailuresAfterTransactionTimeout;
    private double transactionTimeoutWarningRatio = -1.0;
    private boolean finished = false;

    public TwoPhaseCommitSinkFunction(TypeSerializer<TXN> transactionSerializer, TypeSerializer<CONTEXT> contextSerializer) {
        this(transactionSerializer, contextSerializer, Clock.systemUTC());
    }

    @VisibleForTesting
    TwoPhaseCommitSinkFunction(TypeSerializer<TXN> transactionSerializer, TypeSerializer<CONTEXT> contextSerializer, Clock clock) {
        this.stateDescriptor = new ListStateDescriptor("state", new StateSerializer<TXN, CONTEXT>(transactionSerializer, contextSerializer));
        this.clock = clock;
    }

    protected Optional<CONTEXT> initializeUserContext() {
        return Optional.empty();
    }

    protected Optional<CONTEXT> getUserContext() {
        return this.userContext;
    }

    @Nullable
    protected TXN currentTransaction() {
        return this.currentTransactionHolder == null ? null : (TXN)this.currentTransactionHolder.handle;
    }

    @Nonnull
    protected Stream<Map.Entry<Long, TXN>> pendingTransactions() {
        return this.pendingCommitTransactions.entrySet().stream().map(e -> new AbstractMap.SimpleEntry((Long)e.getKey(), ((TransactionHolder)e.getValue()).handle));
    }

    protected abstract void invoke(TXN var1, IN var2, SinkFunction.Context var3) throws Exception;

    protected abstract TXN beginTransaction() throws Exception;

    protected abstract void preCommit(TXN var1) throws Exception;

    protected abstract void commit(TXN var1);

    protected void recoverAndCommit(TXN transaction) {
        this.commit(transaction);
    }

    protected abstract void abort(TXN var1);

    protected void recoverAndAbort(TXN transaction) {
        this.abort(transaction);
    }

    protected void finishRecoveringContext(Collection<TXN> handledTransactions) {
    }

    protected void finishProcessing(@Nullable TXN transaction) {
    }

    public final void invoke(IN value) throws Exception {
    }

    public final void invoke(IN value, SinkFunction.Context context) throws Exception {
        TXN currentTransaction = this.currentTransaction();
        Preconditions.checkNotNull(currentTransaction, (String)"Two phase commit sink function with null transaction should not be invoked! ");
        this.invoke(currentTransaction, value, context);
    }

    public final void finish() throws Exception {
        this.finished = true;
        this.finishProcessing(this.currentTransaction());
    }

    public final void notifyCheckpointComplete(long checkpointId) throws Exception {
        Iterator<Map.Entry<Long, TransactionHolder<TXN>>> pendingTransactionIterator = this.pendingCommitTransactions.entrySet().iterator();
        Throwable firstError = null;
        while (pendingTransactionIterator.hasNext()) {
            TransactionHolder<TXN> pendingTransaction;
            block4: {
                Map.Entry<Long, TransactionHolder<TXN>> entry = pendingTransactionIterator.next();
                Long pendingTransactionCheckpointId = entry.getKey();
                pendingTransaction = entry.getValue();
                if (pendingTransactionCheckpointId > checkpointId) continue;
                LOG.info("{} - checkpoint {} complete, committing transaction {} from checkpoint {}", new Object[]{this.name(), checkpointId, pendingTransaction, pendingTransactionCheckpointId});
                this.logWarningIfTimeoutAlmostReached(pendingTransaction);
                try {
                    this.commit(pendingTransaction.handle);
                }
                catch (Throwable t) {
                    if (firstError != null) break block4;
                    firstError = t;
                }
            }
            LOG.debug("{} - committed checkpoint transaction {}", (Object)this.name(), pendingTransaction);
            pendingTransactionIterator.remove();
        }
        if (firstError != null) {
            throw new FlinkRuntimeException("Committing one of transactions failed, logging first encountered failure", firstError);
        }
    }

    public void notifyCheckpointAborted(long checkpointId) {
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        long checkpointId = context.getCheckpointId();
        LOG.debug("{} - checkpoint {} triggered, flushing transaction '{}'", new Object[]{this.name(), context.getCheckpointId(), this.currentTransactionHolder});
        if (this.currentTransactionHolder != null) {
            this.preCommit(this.currentTransactionHolder.handle);
            this.pendingCommitTransactions.put(checkpointId, this.currentTransactionHolder);
            LOG.debug("{} - stored pending transactions {}", (Object)this.name(), this.pendingCommitTransactions);
        }
        this.currentTransactionHolder = !this.finished ? this.beginTransactionInternal() : null;
        LOG.debug("{} - started new transaction '{}'", (Object)this.name(), this.currentTransactionHolder);
        this.state.update(Collections.singletonList(new State<TXN, CONTEXT>(this.currentTransactionHolder, new ArrayList<TransactionHolder<TXN>>(this.pendingCommitTransactions.values()), this.userContext)));
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        this.state = context.getOperatorStateStore().getListState(this.stateDescriptor);
        boolean recoveredUserContext = false;
        if (context.isRestored()) {
            LOG.info("{} - restoring state", (Object)this.name());
            for (State operatorState : (Iterable)this.state.get()) {
                this.userContext = operatorState.getContext();
                List recoveredTransactions = operatorState.getPendingCommitTransactions();
                ArrayList handledTransactions = new ArrayList(recoveredTransactions.size() + 1);
                for (TransactionHolder recoveredTransaction : recoveredTransactions) {
                    this.recoverAndCommitInternal(recoveredTransaction);
                    handledTransactions.add(recoveredTransaction.handle);
                    LOG.info("{} committed recovered transaction {}", (Object)this.name(), recoveredTransaction);
                }
                if (operatorState.getPendingTransaction() != null) {
                    Object transaction = operatorState.getPendingTransaction().handle;
                    this.recoverAndAbort(transaction);
                    handledTransactions.add(transaction);
                    LOG.info("{} aborted recovered transaction {}", (Object)this.name(), operatorState.getPendingTransaction());
                }
                if (!this.userContext.isPresent()) continue;
                this.finishRecoveringContext(handledTransactions);
                recoveredUserContext = true;
            }
        }
        if (!recoveredUserContext) {
            LOG.info("{} - no state to restore", (Object)this.name());
            this.userContext = this.initializeUserContext();
        }
        this.pendingCommitTransactions.clear();
        this.currentTransactionHolder = this.beginTransactionInternal();
        LOG.debug("{} - started new transaction '{}'", (Object)this.name(), this.currentTransactionHolder);
    }

    private TransactionHolder<TXN> beginTransactionInternal() throws Exception {
        return new TransactionHolder<TXN>(this.beginTransaction(), this.clock.millis());
    }

    private void recoverAndCommitInternal(TransactionHolder<TXN> transactionHolder) {
        try {
            this.logWarningIfTimeoutAlmostReached(transactionHolder);
            this.recoverAndCommit(transactionHolder.handle);
        }
        catch (Exception e) {
            long elapsedTime = this.clock.millis() - transactionHolder.transactionStartTime;
            if (this.ignoreFailuresAfterTransactionTimeout && elapsedTime > this.transactionTimeout) {
                LOG.error("Error while committing transaction {}. Transaction has been open for longer than the transaction timeout ({}).Commit will not be attempted again. Data loss might have occurred.", new Object[]{transactionHolder.handle, this.transactionTimeout, e});
            }
            throw e;
        }
    }

    private void logWarningIfTimeoutAlmostReached(TransactionHolder<TXN> transactionHolder) {
        long elapsedTime = transactionHolder.elapsedTime(this.clock);
        if (this.transactionTimeoutWarningRatio >= 0.0 && (double)elapsedTime > (double)this.transactionTimeout * this.transactionTimeoutWarningRatio) {
            LOG.warn("Transaction {} has been open for {} ms. This is close to or even exceeding the transaction timeout of {} ms.", new Object[]{transactionHolder.handle, elapsedTime, this.transactionTimeout});
        }
    }

    public void close() throws Exception {
        super.close();
        TXN currentTransaction = this.currentTransaction();
        if (currentTransaction != null) {
            this.abort(currentTransaction);
        }
        this.currentTransactionHolder = null;
    }

    protected TwoPhaseCommitSinkFunction<IN, TXN, CONTEXT> setTransactionTimeout(long transactionTimeout) {
        Preconditions.checkArgument((transactionTimeout >= 0L ? 1 : 0) != 0, (Object)"transactionTimeout must not be negative");
        this.transactionTimeout = transactionTimeout;
        return this;
    }

    protected TwoPhaseCommitSinkFunction<IN, TXN, CONTEXT> ignoreFailuresAfterTransactionTimeout() {
        this.ignoreFailuresAfterTransactionTimeout = true;
        return this;
    }

    protected TwoPhaseCommitSinkFunction<IN, TXN, CONTEXT> enableTransactionTimeoutWarnings(double warningRatio) {
        Preconditions.checkArgument((warningRatio >= 0.0 && warningRatio <= 1.0 ? 1 : 0) != 0, (Object)"warningRatio must be in range [0,1]");
        this.transactionTimeoutWarningRatio = warningRatio;
        return this;
    }

    private String name() {
        return String.format("%s %s/%s", ((Object)((Object)this)).getClass().getSimpleName(), this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask() + 1, this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks());
    }

    @Internal
    public static final class StateSerializerSnapshot<TXN, CONTEXT>
    extends CompositeTypeSerializerSnapshot<State<TXN, CONTEXT>, StateSerializer<TXN, CONTEXT>> {
        private static final int VERSION = 4;
        private static final int FIRST_VERSION_SUPPORTING_NULL_TRANSACTIONS = 3;
        private boolean supportsNullTransaction = true;

        public StateSerializerSnapshot() {
        }

        StateSerializerSnapshot(StateSerializer<TXN, CONTEXT> serializerInstance) {
            super(serializerInstance);
            this.supportsNullTransaction = serializerInstance.supportNullPendingTransaction;
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 4;
        }

        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.supportsNullTransaction = readOuterSnapshotVersion < 3 ? false : (readOuterSnapshotVersion == 3 ? true : in.readBoolean());
        }

        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            out.writeBoolean(this.supportsNullTransaction);
        }

        protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(TypeSerializerSnapshot<State<TXN, CONTEXT>> oldSerializerSnapshot) {
            if (!(oldSerializerSnapshot instanceof StateSerializerSnapshot)) {
                return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
            }
            StateSerializerSnapshot oldStateSerializerSnapshot = (StateSerializerSnapshot)oldSerializerSnapshot;
            if (this.supportsNullTransaction != oldStateSerializerSnapshot.supportsNullTransaction) {
                return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION;
            }
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
        }

        protected StateSerializer<TXN, CONTEXT> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> transactionSerializer = nestedSerializers[0];
            TypeSerializer<?> contextSerializer = nestedSerializers[1];
            return new StateSerializer(transactionSerializer, contextSerializer, this.supportsNullTransaction);
        }

        protected TypeSerializer<?>[] getNestedSerializers(StateSerializer<TXN, CONTEXT> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.transactionSerializer, outerSerializer.contextSerializer};
        }
    }

    @VisibleForTesting
    @Internal
    public static final class StateSerializer<TXN, CONTEXT>
    extends TypeSerializer<State<TXN, CONTEXT>> {
        private static final long serialVersionUID = 1L;
        private final TypeSerializer<TXN> transactionSerializer;
        private final TypeSerializer<CONTEXT> contextSerializer;
        private final boolean supportNullPendingTransaction;

        public StateSerializer(TypeSerializer<TXN> transactionSerializer, TypeSerializer<CONTEXT> contextSerializer) {
            this(transactionSerializer, contextSerializer, true);
        }

        public StateSerializer(TypeSerializer<TXN> transactionSerializer, TypeSerializer<CONTEXT> contextSerializer, boolean supportNullPendingTransaction) {
            this.transactionSerializer = (TypeSerializer)Preconditions.checkNotNull(transactionSerializer);
            this.contextSerializer = (TypeSerializer)Preconditions.checkNotNull(contextSerializer);
            this.supportNullPendingTransaction = supportNullPendingTransaction;
        }

        public boolean isImmutableType() {
            return this.transactionSerializer.isImmutableType() && this.contextSerializer.isImmutableType();
        }

        public TypeSerializer<State<TXN, CONTEXT>> duplicate() {
            return new StateSerializer<TXN, CONTEXT>(this.transactionSerializer.duplicate(), this.contextSerializer.duplicate(), this.supportNullPendingTransaction);
        }

        public State<TXN, CONTEXT> createInstance() {
            return null;
        }

        public State<TXN, CONTEXT> copy(State<TXN, CONTEXT> from) {
            TransactionHolder<TXN> pendingTransaction = from.getPendingTransaction();
            TransactionHolder<Object> copiedPendingTransaction = pendingTransaction == null ? null : new TransactionHolder<Object>(this.transactionSerializer.copy(pendingTransaction.handle), pendingTransaction.transactionStartTime);
            ArrayList copiedPendingCommitTransactions = new ArrayList();
            for (TransactionHolder<TXN> txn : from.getPendingCommitTransactions()) {
                Object txnHandleCopy = this.transactionSerializer.copy(txn.handle);
                copiedPendingCommitTransactions.add(new TransactionHolder<Object>(txnHandleCopy, txn.transactionStartTime));
            }
            Optional<Object> copiedContext = from.getContext().map(arg_0 -> this.contextSerializer.copy(arg_0));
            return new State<Object, Object>(copiedPendingTransaction, copiedPendingCommitTransactions, copiedContext);
        }

        public State<TXN, CONTEXT> copy(State<TXN, CONTEXT> from, State<TXN, CONTEXT> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(State<TXN, CONTEXT> record, DataOutputView target) throws IOException {
            TransactionHolder<TXN> pendingTransaction = record.getPendingTransaction();
            this.serializePendingTransaction(pendingTransaction, target);
            List<TransactionHolder<TXN>> pendingCommitTransactions = record.getPendingCommitTransactions();
            target.writeInt(pendingCommitTransactions.size());
            for (TransactionHolder<TXN> pendingTxn : pendingCommitTransactions) {
                this.transactionSerializer.serialize(pendingTxn.handle, target);
                target.writeLong(pendingTxn.transactionStartTime);
            }
            Optional<CONTEXT> context = record.getContext();
            if (context.isPresent()) {
                target.writeBoolean(true);
                this.contextSerializer.serialize(context.get(), target);
            } else {
                target.writeBoolean(false);
            }
        }

        public State<TXN, CONTEXT> deserialize(DataInputView source) throws IOException {
            TransactionHolder<TXN> pendingTxn = this.deserializePendingTransaction(source);
            int numPendingCommitTxns = source.readInt();
            ArrayList pendingCommitTxns = new ArrayList(numPendingCommitTxns);
            for (int i = 0; i < numPendingCommitTxns; ++i) {
                Object pendingCommitTxnHandle = this.transactionSerializer.deserialize(source);
                long pendingCommitTxnStartTime = source.readLong();
                pendingCommitTxns.add(new TransactionHolder<Object>(pendingCommitTxnHandle, pendingCommitTxnStartTime));
            }
            Optional<Object> context = Optional.empty();
            boolean hasContext = source.readBoolean();
            if (hasContext) {
                context = Optional.of(this.contextSerializer.deserialize(source));
            }
            return new State(pendingTxn, pendingCommitTxns, context);
        }

        private void serializePendingTransaction(@Nullable TransactionHolder<TXN> pendingTransaction, DataOutputView target) throws IOException {
            if (this.supportNullPendingTransaction) {
                target.writeBoolean(pendingTransaction != null);
            } else {
                Preconditions.checkState((pendingTransaction != null ? 1 : 0) != 0, (Object)"Received null pending transaction while the serializer does not support null pending transaction.");
            }
            if (pendingTransaction != null) {
                this.transactionSerializer.serialize(pendingTransaction.handle, target);
                target.writeLong(pendingTransaction.transactionStartTime);
            }
        }

        private TransactionHolder<TXN> deserializePendingTransaction(DataInputView source) throws IOException {
            boolean hasPendingTransaction;
            boolean bl = hasPendingTransaction = this.supportNullPendingTransaction ? source.readBoolean() : true;
            if (!hasPendingTransaction) {
                return null;
            }
            Object pendingTxnHandle = this.transactionSerializer.deserialize(source);
            long pendingTxnStartTime = source.readLong();
            return new TransactionHolder<Object>(pendingTxnHandle, pendingTxnStartTime);
        }

        public State<TXN, CONTEXT> deserialize(State<TXN, CONTEXT> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            TransactionHolder<TXN> pendingTransaction = this.deserializePendingTransaction(source);
            this.serializePendingTransaction(pendingTransaction, target);
            int numPendingCommitTxns = source.readInt();
            target.writeInt(numPendingCommitTxns);
            for (int i = 0; i < numPendingCommitTxns; ++i) {
                Object pendingCommitTxnHandle = this.transactionSerializer.deserialize(source);
                this.transactionSerializer.serialize(pendingCommitTxnHandle, target);
                long pendingCommitTxnStartTime = source.readLong();
                target.writeLong(pendingCommitTxnStartTime);
            }
            boolean hasContext = source.readBoolean();
            target.writeBoolean(hasContext);
            if (hasContext) {
                Object context = this.contextSerializer.deserialize(source);
                this.contextSerializer.serialize(context, target);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            StateSerializer that = (StateSerializer)((Object)o);
            if (!this.transactionSerializer.equals(that.transactionSerializer)) {
                return false;
            }
            return this.contextSerializer.equals(that.contextSerializer);
        }

        public int hashCode() {
            int result = this.transactionSerializer.hashCode();
            result = 31 * result + this.contextSerializer.hashCode();
            return result;
        }

        public StateSerializerSnapshot<TXN, CONTEXT> snapshotConfiguration() {
            return new StateSerializerSnapshot(this);
        }
    }

    @VisibleForTesting
    @Internal
    public static final class TransactionHolder<TXN> {
        private final TXN handle;
        private final long transactionStartTime;

        @VisibleForTesting
        public TransactionHolder(TXN handle, long transactionStartTime) {
            this.handle = handle;
            this.transactionStartTime = transactionStartTime;
        }

        @VisibleForTesting
        public long elapsedTime(Clock clock) {
            return clock.millis() - this.transactionStartTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionHolder that = (TransactionHolder)o;
            return this.transactionStartTime == that.transactionStartTime && Objects.equals(this.handle, that.handle);
        }

        public int hashCode() {
            int result = this.handle != null ? this.handle.hashCode() : 0;
            result = 31 * result + (int)(this.transactionStartTime ^ this.transactionStartTime >>> 32);
            return result;
        }

        public String toString() {
            return "TransactionHolder{handle=" + this.handle + ", transactionStartTime=" + this.transactionStartTime + "}";
        }
    }

    @VisibleForTesting
    @Internal
    public static final class State<TXN, CONTEXT> {
        @Nullable
        protected TransactionHolder<TXN> pendingTransaction;
        protected List<TransactionHolder<TXN>> pendingCommitTransactions = new ArrayList<TransactionHolder<TXN>>();
        protected Optional<CONTEXT> context;

        public State() {
        }

        public State(@Nullable TransactionHolder<TXN> pendingTransaction, List<TransactionHolder<TXN>> pendingCommitTransactions, Optional<CONTEXT> context) {
            this.pendingTransaction = pendingTransaction;
            this.pendingCommitTransactions = Objects.requireNonNull(pendingCommitTransactions, "pendingCommitTransactions is null");
            this.context = Objects.requireNonNull(context, "context is null");
        }

        @Nullable
        public TransactionHolder<TXN> getPendingTransaction() {
            return this.pendingTransaction;
        }

        public void setPendingTransaction(@Nullable TransactionHolder<TXN> pendingTransaction) {
            this.pendingTransaction = pendingTransaction;
        }

        public List<TransactionHolder<TXN>> getPendingCommitTransactions() {
            return this.pendingCommitTransactions;
        }

        public void setPendingCommitTransactions(List<TransactionHolder<TXN>> pendingCommitTransactions) {
            this.pendingCommitTransactions = pendingCommitTransactions;
        }

        public Optional<CONTEXT> getContext() {
            return this.context;
        }

        public void setContext(Optional<CONTEXT> context) {
            this.context = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equals(this.pendingTransaction, state.pendingTransaction) && Objects.equals(this.pendingCommitTransactions, state.pendingCommitTransactions) && Objects.equals(this.context, state.context);
        }

        public int hashCode() {
            int result = this.pendingTransaction != null ? this.pendingTransaction.hashCode() : 0;
            result = 31 * result + (this.pendingCommitTransactions != null ? this.pendingCommitTransactions.hashCode() : 0);
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            return result;
        }
    }
}

