/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;

@Experimental
public final class DataStreamUtils {
    public static <T, K> KeyedStream<T, K> reinterpretAsKeyedStream(DataStream<T> stream, KeySelector<T, K> keySelector) {
        return DataStreamUtils.reinterpretAsKeyedStream(stream, keySelector, TypeExtractor.getKeySelectorTypes(keySelector, (TypeInformation)stream.getType()));
    }

    public static <T, K> KeyedStream<T, K> reinterpretAsKeyedStream(DataStream<T> stream, KeySelector<T, K> keySelector, TypeInformation<K> typeInfo) {
        PartitionTransformation partitionTransformation = new PartitionTransformation(stream.getTransformation(), (StreamPartitioner)new ForwardPartitioner());
        return new KeyedStream(stream, partitionTransformation, keySelector, typeInfo);
    }

    private DataStreamUtils() {
    }
}

