/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.connector.sink2.SupportsCommitter;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorTestBase;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;

class WithAdapterCommitterOperatorTest
extends CommitterOperatorTestBase {
    WithAdapterCommitterOperatorTest() {
    }

    @Override
    CommitterOperatorTestBase.SinkAndCounters sinkWithPostCommit() {
        ForwardingCommitter committer = new ForwardingCommitter();
        return new CommitterOperatorTestBase.SinkAndCounters((SupportsCommitter<String>)((SupportsCommitter)TestSink.newBuilder().setCommitter(committer).setDefaultGlobalCommitter().build().asV2()), () -> committer.successfulCommits);
    }

    @Override
    CommitterOperatorTestBase.SinkAndCounters sinkWithPostCommitWithRetry() {
        return new CommitterOperatorTestBase.SinkAndCounters((SupportsCommitter<String>)((SupportsCommitter)TestSink.newBuilder().setCommitter(new TestSink.RetryOnceCommitter()).setDefaultGlobalCommitter().build().asV2()), () -> 0);
    }

    @Override
    CommitterOperatorTestBase.SinkAndCounters sinkWithoutPostCommit() {
        ForwardingCommitter committer = new ForwardingCommitter();
        return new CommitterOperatorTestBase.SinkAndCounters((SupportsCommitter<String>)((SupportsCommitter)TestSink.newBuilder().setCommitter(committer).build().asV2()), () -> committer.successfulCommits);
    }

    private static class ForwardingCommitter
    extends TestSink.DefaultCommitter {
        private int successfulCommits = 0;

        private ForwardingCommitter() {
        }

        @Override
        public List<String> commit(List<String> committables) {
            this.successfulCommits += committables.size();
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }
    }
}

