/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReceiverThread
extends CheckedThread {
    protected static final Logger LOG = LoggerFactory.getLogger(ReceiverThread.class);
    protected final int expectedRepetitionsOfExpectedRecord;
    protected int expectedRecordCounter;
    protected CompletableFuture<Long> expectedRecord = new CompletableFuture();
    protected CompletableFuture<?> recordsProcessed = new CompletableFuture();
    protected volatile boolean running;

    ReceiverThread(int expectedRepetitionsOfExpectedRecord) {
        this.setName(((Object)((Object)this)).getClass().getName());
        this.expectedRepetitionsOfExpectedRecord = expectedRepetitionsOfExpectedRecord;
        this.running = true;
    }

    public synchronized CompletableFuture<?> setExpectedRecord(long record) {
        Preconditions.checkState((!this.expectedRecord.isDone() ? 1 : 0) != 0);
        Preconditions.checkState((!this.recordsProcessed.isDone() ? 1 : 0) != 0);
        this.expectedRecord.complete(record);
        this.expectedRecordCounter = 0;
        return this.recordsProcessed;
    }

    private synchronized CompletableFuture<Long> getExpectedRecord() {
        return this.expectedRecord;
    }

    private synchronized void finishProcessingExpectedRecords() {
        Preconditions.checkState((boolean)this.expectedRecord.isDone());
        Preconditions.checkState((!this.recordsProcessed.isDone() ? 1 : 0) != 0);
        this.recordsProcessed.complete(null);
        this.expectedRecord = new CompletableFuture();
        this.recordsProcessed = new CompletableFuture();
    }

    public void go() throws Exception {
        try {
            while (this.running) {
                this.readRecords(this.getExpectedRecord().get());
                this.finishProcessingExpectedRecords();
            }
        }
        catch (InterruptedException e) {
            if (this.running) {
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void readRecords(long var1) throws Exception;

    public void shutdown() {
        this.running = false;
        this.interrupt();
        this.expectedRecord.complete(0L);
    }
}

