/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorAttributes;
import org.apache.flink.streaming.api.operators.OperatorAttributesBuilder;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class PartitionAggregateOperator<IN, ACC, OUT>
extends AbstractUdfStreamOperator<OUT, AggregateFunction<IN, ACC, OUT>>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private final AggregateFunction<IN, ACC, OUT> aggregateFunction;
    private ACC currentAccumulator = null;

    public PartitionAggregateOperator(AggregateFunction<IN, ACC, OUT> aggregateFunction) {
        super(aggregateFunction);
        this.aggregateFunction = aggregateFunction;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.currentAccumulator = Preconditions.checkNotNull((Object)this.aggregateFunction.createAccumulator());
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.aggregateFunction.add(element.getValue(), this.currentAccumulator);
    }

    @Override
    public void endInput() throws Exception {
        this.output.collect(new StreamRecord<Object>(this.aggregateFunction.getResult(this.currentAccumulator)));
    }

    @Override
    public OperatorAttributes getOperatorAttributes() {
        return new OperatorAttributesBuilder().setOutputOnlyAfterEndOfStream(true).build();
    }
}

