/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.restore;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricMonitor;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricOptions;
import org.apache.flink.contrib.streaming.state.RocksDBOperationUtils;
import org.apache.flink.contrib.streaming.state.ttl.RocksDbTtlCompactFiltersManager;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RocksDBHandle
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory;
    private final DBOptions dbOptions;
    private final Map<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation;
    private final String dbPath;
    private List<ColumnFamilyHandle> columnFamilyHandles;
    private List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    private final RocksDBNativeMetricOptions nativeMetricOptions;
    private final MetricGroup metricGroup;
    private final RocksDbTtlCompactFiltersManager ttlCompactFiltersManager;
    private RocksDB db;
    private ColumnFamilyHandle defaultColumnFamilyHandle;
    private RocksDBNativeMetricMonitor nativeMetricMonitor;
    private final Long writeBufferManagerCapacity;

    protected RocksDBHandle(Map<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation, File instanceRocksDBPath, DBOptions dbOptions, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, RocksDBNativeMetricOptions nativeMetricOptions, MetricGroup metricGroup, @Nonnull RocksDbTtlCompactFiltersManager ttlCompactFiltersManager, Long writeBufferManagerCapacity) {
        this.kvStateInformation = kvStateInformation;
        this.dbPath = instanceRocksDBPath.getAbsolutePath();
        this.dbOptions = dbOptions;
        this.columnFamilyOptionsFactory = columnFamilyOptionsFactory;
        this.nativeMetricOptions = nativeMetricOptions;
        this.metricGroup = metricGroup;
        this.ttlCompactFiltersManager = ttlCompactFiltersManager;
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(1);
        this.columnFamilyDescriptors = Collections.emptyList();
        this.writeBufferManagerCapacity = writeBufferManagerCapacity;
    }

    void openDB() throws IOException {
        this.loadDb();
    }

    void openDB(@Nonnull List<ColumnFamilyDescriptor> columnFamilyDescriptors, @Nonnull List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, @Nonnull Path restoreSourcePath) throws IOException {
        this.columnFamilyDescriptors = columnFamilyDescriptors;
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(columnFamilyDescriptors.size() + 1);
        this.restoreInstanceDirectoryFromPath(restoreSourcePath);
        this.loadDb();
        for (int i = 0; i < stateMetaInfoSnapshots.size(); ++i) {
            this.getOrRegisterStateColumnFamilyHandle(this.columnFamilyHandles.get(i), stateMetaInfoSnapshots.get(i));
        }
    }

    private void loadDb() throws IOException {
        this.db = RocksDBOperationUtils.openDB(this.dbPath, this.columnFamilyDescriptors, this.columnFamilyHandles, RocksDBOperationUtils.createColumnFamilyOptions(this.columnFamilyOptionsFactory, "default"), this.dbOptions);
        this.defaultColumnFamilyHandle = this.columnFamilyHandles.remove(0);
        this.nativeMetricMonitor = this.nativeMetricOptions.isEnabled() ? new RocksDBNativeMetricMonitor(this.nativeMetricOptions, this.metricGroup, this.db) : null;
    }

    RocksDBKeyedStateBackend.RocksDbKvStateInfo getOrRegisterStateColumnFamilyHandle(ColumnFamilyHandle columnFamilyHandle, StateMetaInfoSnapshot stateMetaInfoSnapshot) {
        RocksDBKeyedStateBackend.RocksDbKvStateInfo registeredStateMetaInfoEntry = this.kvStateInformation.get(stateMetaInfoSnapshot.getName());
        if (null == registeredStateMetaInfoEntry) {
            RegisteredStateMetaInfoBase stateMetaInfo = RegisteredStateMetaInfoBase.fromMetaInfoSnapshot((StateMetaInfoSnapshot)stateMetaInfoSnapshot);
            registeredStateMetaInfoEntry = columnFamilyHandle == null ? RocksDBOperationUtils.createStateInfo(stateMetaInfo, this.db, this.columnFamilyOptionsFactory, this.ttlCompactFiltersManager, this.writeBufferManagerCapacity) : new RocksDBKeyedStateBackend.RocksDbKvStateInfo(columnFamilyHandle, stateMetaInfo);
            RocksDBOperationUtils.registerKvStateInformation(this.kvStateInformation, this.nativeMetricMonitor, stateMetaInfoSnapshot.getName(), registeredStateMetaInfoEntry);
        }
        return registeredStateMetaInfoEntry;
    }

    private void restoreInstanceDirectoryFromPath(Path source) throws IOException {
        Path instanceRocksDBDirectory = Paths.get(this.dbPath, new String[0]);
        Path[] files = FileUtils.listDirectory((Path)source);
        if (!new File(this.dbPath).mkdirs()) {
            String errMsg = "Could not create RocksDB data directory: " + this.dbPath;
            this.logger.error(errMsg);
            throw new IOException(errMsg);
        }
        for (Path file : files) {
            String fileName = file.getFileName().toString();
            Path targetFile = instanceRocksDBDirectory.resolve(fileName);
            if (fileName.endsWith(".sst")) {
                try {
                    Files.createLink(targetFile, file);
                    continue;
                }
                catch (IOException ioe) {
                    String logMessage = String.format("Could not hard link sst file %s. Trying to copy it over. This might increase the recovery time. In order to avoid this, configure RocksDB's working directory and the local state directory to be on the same volume.", fileName);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(logMessage, (Throwable)ioe);
                    }
                    this.logger.info(logMessage);
                }
            }
            Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public RocksDB getDb() {
        return this.db;
    }

    public RocksDBNativeMetricMonitor getNativeMetricMonitor() {
        return this.nativeMetricMonitor;
    }

    public ColumnFamilyHandle getDefaultColumnFamilyHandle() {
        return this.defaultColumnFamilyHandle;
    }

    public List<ColumnFamilyHandle> getColumnFamilyHandles() {
        return this.columnFamilyHandles;
    }

    public RocksDbTtlCompactFiltersManager getTtlCompactFiltersManager() {
        return this.ttlCompactFiltersManager;
    }

    public Long getWriteBufferManagerCapacity() {
        return this.writeBufferManagerCapacity;
    }

    public Function<String, ColumnFamilyOptions> getColumnFamilyOptionsFactory() {
        return this.columnFamilyOptionsFactory;
    }

    public DBOptions getDbOptions() {
        return this.dbOptions;
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeQuietly((AutoCloseable)this.defaultColumnFamilyHandle);
        IOUtils.closeQuietly((AutoCloseable)this.nativeMetricMonitor);
        IOUtils.closeQuietly((AutoCloseable)this.db);
        this.columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
    }
}

