/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.ArrayList;
import java.util.Collection;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.TableFormatConfig;

public enum PredefinedOptions {
    DEFAULT{

        @Override
        public DBOptions createDBOptions(Collection<AutoCloseable> handlesToClose) {
            return new DBOptions().setUseFsync(false).setInfoLogLevel(InfoLogLevel.HEADER_LEVEL).setStatsDumpPeriodSec(0);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions(Collection<AutoCloseable> handlesToClose) {
            return new ColumnFamilyOptions();
        }
    }
    ,
    SPINNING_DISK_OPTIMIZED{

        @Override
        public DBOptions createDBOptions(Collection<AutoCloseable> handlesToClose) {
            return new DBOptions().setIncreaseParallelism(4).setUseFsync(false).setMaxOpenFiles(-1).setInfoLogLevel(InfoLogLevel.HEADER_LEVEL).setStatsDumpPeriodSec(0);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions(Collection<AutoCloseable> handlesToClose) {
            return new ColumnFamilyOptions().setCompactionStyle(CompactionStyle.LEVEL).setLevelCompactionDynamicLevelBytes(true);
        }
    }
    ,
    SPINNING_DISK_OPTIMIZED_HIGH_MEM{

        @Override
        public DBOptions createDBOptions(Collection<AutoCloseable> handlesToClose) {
            return new DBOptions().setIncreaseParallelism(4).setUseFsync(false).setMaxOpenFiles(-1).setInfoLogLevel(InfoLogLevel.HEADER_LEVEL).setStatsDumpPeriodSec(0);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions(Collection<AutoCloseable> handlesToClose) {
            long blockCacheSize = 0x10000000L;
            long blockSize = 131072L;
            long targetFileSize = 0x10000000L;
            long writeBufferSize = 0x4000000L;
            BloomFilter bloomFilter = new BloomFilter();
            handlesToClose.add((AutoCloseable)bloomFilter);
            return new ColumnFamilyOptions().setCompactionStyle(CompactionStyle.LEVEL).setLevelCompactionDynamicLevelBytes(true).setTargetFileSizeBase(0x10000000L).setMaxBytesForLevelBase(0x40000000L).setWriteBufferSize(0x4000000L).setMinWriteBufferNumberToMerge(3).setMaxWriteBufferNumber(4).setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setBlockCacheSize(0x10000000L).setBlockSize(131072L).setFilter((Filter)bloomFilter));
        }
    }
    ,
    FLASH_SSD_OPTIMIZED{

        @Override
        public DBOptions createDBOptions(Collection<AutoCloseable> handlesToClose) {
            return new DBOptions().setIncreaseParallelism(4).setUseFsync(false).setMaxOpenFiles(-1).setInfoLogLevel(InfoLogLevel.HEADER_LEVEL).setStatsDumpPeriodSec(0);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions(Collection<AutoCloseable> handlesToClose) {
            return new ColumnFamilyOptions();
        }
    };


    public abstract DBOptions createDBOptions(Collection<AutoCloseable> var1);

    public DBOptions createDBOptions() {
        return this.createDBOptions(new ArrayList<AutoCloseable>());
    }

    public abstract ColumnFamilyOptions createColumnOptions(Collection<AutoCloseable> var1);

    public ColumnFamilyOptions createColumnOptions() {
        return this.createColumnOptions(new ArrayList<AutoCloseable>());
    }
}

