/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.RocksIteratorWrapper;
import org.apache.flink.contrib.streaming.state.iterator.AbstractRocksStateKeysIterator;
import org.apache.flink.util.FlinkRuntimeException;

public class RocksStateKeysIterator<K>
extends AbstractRocksStateKeysIterator<K>
implements Iterator<K> {
    @Nonnull
    private final byte[] namespaceBytes;
    private K nextKey;
    private K previousKey;

    public RocksStateKeysIterator(@Nonnull RocksIteratorWrapper iterator, @Nonnull String state, @Nonnull TypeSerializer<K> keySerializer, int keyGroupPrefixBytes, boolean ambiguousKeyPossible, @Nonnull byte[] namespaceBytes) {
        super(iterator, state, keySerializer, keyGroupPrefixBytes, ambiguousKeyPossible);
        this.namespaceBytes = namespaceBytes;
        this.nextKey = null;
        this.previousKey = null;
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.nextKey == null && this.iterator.isValid()) {
                byte[] keyBytes = this.iterator.key();
                Object currentKey = this.deserializeKey(keyBytes, this.byteArrayDataInputView);
                if (RocksStateKeysIterator.isMatchingNameSpace(keyBytes, this.byteArrayDataInputView.getPosition(), this.namespaceBytes) && !Objects.equals(this.previousKey, currentKey)) {
                    this.previousKey = currentKey;
                    this.nextKey = currentKey;
                }
                this.iterator.next();
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to access state [" + this.state + "]", (Throwable)e);
        }
        return this.nextKey != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Failed to access state [" + this.state + "]");
        }
        K tmpKey = this.nextKey;
        this.nextKey = null;
        return tmpKey;
    }
}

