/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentInputStreamWithPos;

class SkipListKeySerializer<K, N> {
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<N> namespaceSerializer;
    private final ByteArrayOutputStreamWithPos outputStream;
    private final DataOutputViewStreamWrapper outputView;

    SkipListKeySerializer(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.outputStream = new ByteArrayOutputStreamWithPos();
        this.outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);
    }

    byte[] serialize(K key, N namespace) {
        return this.serializeToSegment(key, namespace).getArray();
    }

    MemorySegment serializeToSegment(K key, N namespace) {
        this.outputStream.reset();
        try {
            this.outputStream.setPosition(4);
            this.namespaceSerializer.serialize(namespace, (DataOutputView)this.outputView);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize namespace", e);
        }
        int keyStartPos = this.outputStream.getPosition();
        try {
            this.outputStream.setPosition(keyStartPos + 4);
            this.keySerializer.serialize(key, (DataOutputView)this.outputView);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize key", e);
        }
        byte[] result = this.outputStream.toByteArray();
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])result);
        segment.putInt(0, keyStartPos - 4);
        segment.putInt(keyStartPos, result.length - keyStartPos - 4);
        return segment;
    }

    N deserializeNamespace(MemorySegment memorySegment, int offset, int len) {
        MemorySegmentInputStreamWithPos inputStream = new MemorySegmentInputStreamWithPos(memorySegment, offset, len);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        inputStream.setPosition(offset + 4);
        try {
            return (N)this.namespaceSerializer.deserialize((DataInputView)inputView);
        }
        catch (IOException e) {
            throw new RuntimeException("deserialize namespace failed", e);
        }
    }

    K deserializeKey(MemorySegment memorySegment, int offset, int len) {
        MemorySegmentInputStreamWithPos inputStream = new MemorySegmentInputStreamWithPos(memorySegment, offset, len);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        int namespaceLen = memorySegment.getInt(offset);
        inputStream.setPosition(offset + 4 + namespaceLen + 4);
        try {
            return (K)this.keySerializer.deserialize((DataInputView)inputView);
        }
        catch (IOException e) {
            throw new RuntimeException("deserialize key failed", e);
        }
    }

    Tuple2<byte[], byte[]> getSerializedKeyAndNamespace(MemorySegment memorySegment, int offset) {
        int namespaceLen = memorySegment.getInt(offset);
        MemorySegment namespaceSegment = MemorySegmentFactory.allocateUnpooledSegment((int)namespaceLen);
        memorySegment.copyTo(offset + 4, namespaceSegment, 0, namespaceLen);
        int keyOffset = offset + 4 + namespaceLen;
        int keyLen = memorySegment.getInt(keyOffset);
        MemorySegment keySegment = MemorySegmentFactory.allocateUnpooledSegment((int)keyLen);
        memorySegment.copyTo(keyOffset + 4, keySegment, 0, keyLen);
        return Tuple2.of((Object)keySegment.getArray(), (Object)namespaceSegment.getArray());
    }

    byte[] serializeNamespace(N namespace) {
        this.outputStream.reset();
        try {
            this.namespaceSerializer.serialize(namespace, (DataOutputView)this.outputView);
        }
        catch (IOException e) {
            throw new RuntimeException("serialize namespace failed", e);
        }
        return this.outputStream.toByteArray();
    }

    MemorySegment serializeNamespaceToSegment(N namespace) {
        return MemorySegmentFactory.wrap((byte[])this.serializeNamespace(namespace));
    }
}

