/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import org.apache.flink.core.memory.MemorySegment;

class SkipListKeyComparator {
    SkipListKeyComparator() {
    }

    static int compareTo(MemorySegment left, int leftOffset, MemorySegment right, int rightOffset) {
        int rightNamespaceLen;
        int leftNamespaceLen = left.getInt(leftOffset);
        int c = left.compare(right, leftOffset + 4, rightOffset + 4, leftNamespaceLen, rightNamespaceLen = right.getInt(rightOffset));
        if (c != 0) {
            return c;
        }
        int leftKeyOffset = leftOffset + 4 + leftNamespaceLen;
        int rightKeyOffset = rightOffset + 4 + rightNamespaceLen;
        int leftKeyLen = left.getInt(leftKeyOffset);
        int rightKeyLen = right.getInt(rightKeyOffset);
        return left.compare(right, leftKeyOffset + 4, rightKeyOffset + 4, leftKeyLen, rightKeyLen);
    }

    static int compareNamespaceAndNode(MemorySegment namespaceSegment, int namespaceOffset, int namespaceLen, MemorySegment nodeSegment, int nodeKeyOffset) {
        int nodeNamespaceLen = nodeSegment.getInt(nodeKeyOffset);
        return namespaceSegment.compare(nodeSegment, namespaceOffset, nodeKeyOffset + 4, namespaceLen, nodeNamespaceLen);
    }
}

