/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import java.io.File;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.state.forst.fs.cache.CacheLimitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceBasedCacheLimitPolicy
implements CacheLimitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceBasedCacheLimitPolicy.class);
    private final long reservedSize;
    private final File instanceBasePath;
    private final long sstFileSize;
    private long usageSize;

    public SpaceBasedCacheLimitPolicy(File instanceBasePath, long reservedSize, long baseTargetFileSize) {
        this.reservedSize = reservedSize;
        this.instanceBasePath = instanceBasePath;
        this.sstFileSize = baseTargetFileSize;
        this.usageSize = 0L;
        long initFreeSpace = instanceBasePath.getFreeSpace();
        if (initFreeSpace < reservedSize || reservedSize < baseTargetFileSize) {
            LOG.warn("Illegal configuration of preserved space, current free space {}, reserve space {} and base targetFile size {} on instance base path {}.", new Object[]{initFreeSpace, reservedSize, baseTargetFileSize, instanceBasePath});
        }
        LOG.info("Creating SpaceBasedCacheLimitPolicy with initFreeSpace {} and preserved space {}", (Object)initFreeSpace, (Object)reservedSize);
    }

    public static boolean worksOn(File instanceBasePath) {
        return instanceBasePath.getFreeSpace() > 0L;
    }

    private boolean isOverSpace(long toAddSize, long leftSpace) {
        return toAddSize > this.instanceBasePath.getFreeSpace() - leftSpace;
    }

    @Override
    public boolean directWriteInCache() {
        return this.isSafeToAdd(this.sstFileSize);
    }

    @Override
    public boolean isSafeToAdd(long toAddSize) {
        return toAddSize <= this.instanceBasePath.getFreeSpace() - this.reservedSize + this.usageSize;
    }

    @Override
    public boolean isOverflow(long toAddSize, boolean hasFile) {
        return this.isOverSpace(hasFile ? 0L : toAddSize, this.reservedSize);
    }

    @Override
    public void acquire(long toAddSize) {
        this.usageSize += toAddSize;
    }

    @Override
    public void release(long toReleaseSize) {
        this.usageSize -= Math.min(this.usageSize, toReleaseSize);
    }

    @Override
    public long usedBytes() {
        return this.usageSize;
    }

    @Override
    public void registerCustomizedMetrics(String prefix, MetricGroup metricGroup) {
        metricGroup.gauge(prefix + ".remainingBytes", () -> this.instanceBasePath.getFreeSpace() - this.reservedSize);
    }

    public String toString() {
        return "SpaceBasedCacheLimitPolicy{reservedSize=" + this.reservedSize + ", instanceBasePath=" + String.valueOf(this.instanceBasePath) + ", usageSize=" + this.usageSize + "}";
    }
}

