/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.state.forst.ForStSharedResources;
import org.forstdb.Cache;
import org.forstdb.LRUCache;
import org.forstdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForStMemoryControllerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ForStMemoryControllerUtils.class);

    public static ForStSharedResources allocateForStSharedResources(long totalMemorySize, double writeBufferRatio, double highPriorityPoolRatio, boolean usingPartitionedIndexFilters, ForStMemoryFactory factory) {
        long calculatedCacheCapacity = ForStMemoryControllerUtils.calculateActualCacheCapacity(totalMemorySize, writeBufferRatio);
        Cache cache = factory.createCache(calculatedCacheCapacity, highPriorityPoolRatio);
        long writeBufferManagerCapacity = ForStMemoryControllerUtils.calculateWriteBufferManagerCapacity(totalMemorySize, writeBufferRatio);
        WriteBufferManager wbm = factory.createWriteBufferManager(writeBufferManagerCapacity, cache);
        LOG.debug("Allocated ForSt shared resources, calculatedCacheCapacity: {}, highPriorityPoolRatio: {}, writeBufferManagerCapacity: {}, usingPartitionedIndexFilters: {}", new Object[]{calculatedCacheCapacity, highPriorityPoolRatio, writeBufferManagerCapacity, usingPartitionedIndexFilters});
        return new ForStSharedResources(cache, wbm, writeBufferManagerCapacity, usingPartitionedIndexFilters);
    }

    @VisibleForTesting
    public static long calculateActualCacheCapacity(long totalMemorySize, double writeBufferRatio) {
        return (long)((3.0 - writeBufferRatio) * (double)totalMemorySize / 3.0);
    }

    @VisibleForTesting
    static long calculateWriteBufferManagerCapacity(long totalMemorySize, double writeBufferRatio) {
        return (long)((double)(2L * totalMemorySize) * writeBufferRatio / 3.0);
    }

    @VisibleForTesting
    static Cache createCache(long cacheCapacity, double highPriorityPoolRatio) {
        return new LRUCache(cacheCapacity, -1, false, highPriorityPoolRatio);
    }

    @VisibleForTesting
    static WriteBufferManager createWriteBufferManager(long writeBufferManagerCapacity, Cache cache) {
        return new WriteBufferManager(writeBufferManagerCapacity, cache);
    }

    static long calculateForStDefaultArenaBlockSize(long writeBufferSize) {
        long arenaBlockSize = writeBufferSize / 8L;
        long align = 4096L;
        return (arenaBlockSize + 4096L - 1L) / 4096L * 4096L;
    }

    static long calculateForStMutableLimit(long bufferSize) {
        return bufferSize * 7L / 8L;
    }

    @VisibleForTesting
    static boolean validateArenaBlockSize(long arenaBlockSize, long mutableLimit) {
        return arenaBlockSize <= mutableLimit;
    }

    public static interface ForStMemoryFactory
    extends Serializable {
        public static final ForStMemoryFactory DEFAULT = new ForStMemoryFactory(){

            @Override
            public Cache createCache(long cacheCapacity, double highPriorityPoolRatio) {
                return ForStMemoryControllerUtils.createCache(cacheCapacity, highPriorityPoolRatio);
            }

            @Override
            public WriteBufferManager createWriteBufferManager(long writeBufferManagerCapacity, Cache cache) {
                return ForStMemoryControllerUtils.createWriteBufferManager(writeBufferManagerCapacity, cache);
            }
        };

        public Cache createCache(long var1, double var3);

        public WriteBufferManager createWriteBufferManager(long var1, Cache var3);
    }
}

