/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.state.forst.ContextKey;

public class ForStSerializerUtils {
    public static <K, N> byte[] serializeKeyAndNamespace(ContextKey<K, N> contextKey, SerializedCompositeKeyBuilder<K> builder, N defaultNamespace, TypeSerializer<N> namespaceSerializer, boolean enableKeyReuse) throws IOException {
        N namespace = contextKey.getNamespace();
        Object n = namespace = namespace == null ? defaultNamespace : namespace;
        if (enableKeyReuse && namespace == defaultNamespace) {
            return contextKey.getOrCreateSerializedKey(ctxKey -> {
                builder.setKeyAndKeyGroup(ctxKey.getRawKey(), ctxKey.getKeyGroup());
                return builder.buildCompositeKeyNamespace(defaultNamespace, namespaceSerializer);
            });
        }
        builder.setKeyAndKeyGroup(contextKey.getRawKey(), contextKey.getKeyGroup());
        return builder.buildCompositeKeyNamespace(namespace, namespaceSerializer);
    }

    private ForStSerializerUtils() {
    }
}

