/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.fs.ICloseableRegistry;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.state.forst.ForStDBTtlCompactFiltersManager;
import org.apache.flink.state.forst.ForStMemoryConfiguration;
import org.apache.flink.state.forst.ForStMemoryControllerUtils;
import org.apache.flink.state.forst.ForStNativeMetricMonitor;
import org.apache.flink.state.forst.ForStSharedResources;
import org.apache.flink.state.forst.ForStSharedResourcesFactory;
import org.apache.flink.state.forst.sync.ForStIteratorWrapper;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.forstdb.ColumnFamilyDescriptor;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.ColumnFamilyOptions;
import org.forstdb.DBOptions;
import org.forstdb.ExportImportFilesMetaData;
import org.forstdb.ImportColumnFamilyOptions;
import org.forstdb.ReadOptions;
import org.forstdb.RocksDB;
import org.forstdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForStOperationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ForStOperationUtils.class);
    public static final String MERGE_OPERATOR_NAME = "stringappendtest";

    public static RocksDB openDB(String path, List<ColumnFamilyDescriptor> stateColumnFamilyDescriptors, List<ColumnFamilyHandle> stateColumnFamilyHandles, ColumnFamilyOptions columnFamilyOptions, DBOptions dbOptions) throws IOException {
        RocksDB dbRef;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>(1 + stateColumnFamilyDescriptors.size());
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions));
        columnFamilyDescriptors.addAll(stateColumnFamilyDescriptors);
        try {
            dbRef = RocksDB.open((DBOptions)((DBOptions)Preconditions.checkNotNull((Object)dbOptions)), (String)((String)Preconditions.checkNotNull((Object)path)), columnFamilyDescriptors, stateColumnFamilyHandles);
        }
        catch (RocksDBException e) {
            IOUtils.closeQuietly((AutoCloseable)columnFamilyOptions);
            columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
            ForStOperationUtils.throwExceptionIfPathLengthExceededOnWindows(path, (Exception)((Object)e));
            throw new IOException("Error while opening ForSt instance.", e);
        }
        Preconditions.checkState((1 + stateColumnFamilyDescriptors.size() == stateColumnFamilyHandles.size() ? 1 : 0) != 0, (Object)"Not all requested column family handles have been created");
        return dbRef;
    }

    private static ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnDescriptor, RocksDB db, List<ExportImportFilesMetaData> importFilesMetaData, ICloseableRegistry cancelStreamRegistryForRestore) throws RocksDBException, InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("The thread was interrupted, aborting recovery");
        }
        if (cancelStreamRegistryForRestore.isClosed()) {
            throw new CancelTaskException("The stream was closed, aborting recovery");
        }
        if (importFilesMetaData.isEmpty()) {
            return db.createColumnFamily(columnDescriptor);
        }
        try (ImportColumnFamilyOptions importColumnFamilyOptions = new ImportColumnFamilyOptions().setMoveFiles(true);){
            ColumnFamilyHandle columnFamilyHandle = db.createColumnFamilyWithImport(columnDescriptor, importColumnFamilyOptions, importFilesMetaData);
            return columnFamilyHandle;
        }
    }

    public static ColumnFamilyOptions createColumnFamilyOptions(Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, String stateName) {
        return columnFamilyOptionsFactory.apply(stateName).setMergeOperatorName(MERGE_OPERATOR_NAME);
    }

    @Nullable
    public static OpaqueMemoryResource<ForStSharedResources> allocateSharedCachesIfConfigured(ForStMemoryConfiguration jobMemoryConfig, Environment env, double memoryFraction, Logger logger, ForStMemoryControllerUtils.ForStMemoryFactory forStMemoryFactory) throws IOException {
        try {
            ForStSharedResourcesFactory factory = ForStSharedResourcesFactory.from(jobMemoryConfig, env);
            if (factory == null) {
                return null;
            }
            return factory.create(jobMemoryConfig, env, memoryFraction, logger, forStMemoryFactory);
        }
        catch (Exception e) {
            throw new IOException("Failed to acquire shared cache resource for ForSt", e);
        }
    }

    public static ForStIteratorWrapper getForStIterator(RocksDB db, ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions) {
        return new ForStIteratorWrapper(db.newIterator(columnFamilyHandle, readOptions));
    }

    public static void addColumnFamilyOptionsToCloseLater(List<ColumnFamilyOptions> columnFamilyOptions, ColumnFamilyHandle columnFamilyHandle) {
        try {
            ColumnFamilyDescriptor columnFamilyDescriptor;
            if (columnFamilyHandle != null && (columnFamilyDescriptor = columnFamilyHandle.getDescriptor()) != null) {
                columnFamilyOptions.add(columnFamilyDescriptor.getOptions());
            }
        }
        catch (RocksDBException rocksDBException) {
            // empty catch block
        }
    }

    public static ForStKvStateInfo createStateInfo(RegisteredStateMetaInfoBase metaInfoBase, RocksDB db, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, @Nullable ForStDBTtlCompactFiltersManager ttlCompactFiltersManager, @Nullable Long writeBufferManagerCapacity, List<ExportImportFilesMetaData> importFilesMetaData, ICloseableRegistry cancelStreamRegistryForRestore) {
        ColumnFamilyDescriptor columnFamilyDescriptor = ForStOperationUtils.createColumnFamilyDescriptor(metaInfoBase, columnFamilyOptionsFactory, ttlCompactFiltersManager, writeBufferManagerCapacity);
        try {
            ColumnFamilyHandle columnFamilyHandle = ForStOperationUtils.createColumnFamily(columnFamilyDescriptor, db, importFilesMetaData, cancelStreamRegistryForRestore);
            return new ForStKvStateInfo(columnFamilyHandle, metaInfoBase);
        }
        catch (Exception ex) {
            IOUtils.closeQuietly((AutoCloseable)columnFamilyDescriptor.getOptions());
            throw new FlinkRuntimeException("Error creating ColumnFamilyHandle.", (Throwable)ex);
        }
    }

    public static ForStKvStateInfo createStateInfo(RegisteredStateMetaInfoBase metaInfoBase, RocksDB db, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, @Nullable ForStDBTtlCompactFiltersManager ttlCompactFiltersManager, @Nullable Long writeBufferManagerCapacity, ICloseableRegistry cancelStreamRegistryForRestore) {
        return ForStOperationUtils.createStateInfo(metaInfoBase, db, columnFamilyOptionsFactory, ttlCompactFiltersManager, writeBufferManagerCapacity, Collections.emptyList(), cancelStreamRegistryForRestore);
    }

    public static ColumnFamilyDescriptor createColumnFamilyDescriptor(RegisteredStateMetaInfoBase metaInfoBase, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, @Nullable ForStDBTtlCompactFiltersManager ttlCompactFiltersManager, @Nullable Long writeBufferManagerCapacity) {
        byte[] nameBytes = metaInfoBase.getName().getBytes(ConfigConstants.DEFAULT_CHARSET);
        Preconditions.checkState((!Arrays.equals(RocksDB.DEFAULT_COLUMN_FAMILY, nameBytes) ? 1 : 0) != 0, (Object)"The chosen state name 'default' collides with the name of the default column family!");
        ColumnFamilyOptions options = ForStOperationUtils.createColumnFamilyOptions(columnFamilyOptionsFactory, metaInfoBase.getName());
        if (ttlCompactFiltersManager != null) {
            if (metaInfoBase instanceof RegisteredKeyValueStateBackendMetaInfo) {
                ttlCompactFiltersManager.setAndRegisterCompactFilterIfStateTtl(metaInfoBase, options);
            } else {
                ttlCompactFiltersManager.setAndRegisterCompactFilterIfStateTtlV2(metaInfoBase, options);
            }
        }
        if (writeBufferManagerCapacity != null) {
            ForStOperationUtils.sanityCheckArenaBlockSize(options.writeBufferSize(), options.arenaBlockSize(), writeBufferManagerCapacity);
        }
        return new ColumnFamilyDescriptor(nameBytes, options);
    }

    static boolean sanityCheckArenaBlockSize(long writeBufferSize, long arenaBlockSizeConfigured, long writeBufferManagerCapacity) {
        long mutableLimit;
        long defaultArenaBlockSize = ForStMemoryControllerUtils.calculateForStDefaultArenaBlockSize(writeBufferSize);
        long arenaBlockSize = arenaBlockSizeConfigured <= 0L ? defaultArenaBlockSize : arenaBlockSizeConfigured;
        if (ForStMemoryControllerUtils.validateArenaBlockSize(arenaBlockSize, mutableLimit = ForStMemoryControllerUtils.calculateForStMutableLimit(writeBufferManagerCapacity))) {
            return true;
        }
        LOG.warn("ForStStateBackend performance will be poor because of the current Flink memory configuration! RocksDB will flush memtable constantly, causing high IO and CPU. Typically the easiest fix is to increase task manager managed memory size. If running locally, see the parameter taskmanager.memory.managed.size. Details: arenaBlockSize {} > mutableLimit {} (writeBufferSize = {}, arenaBlockSizeConfigured = {}, defaultArenaBlockSize = {}, writeBufferManagerCapacity = {})", new Object[]{arenaBlockSize, mutableLimit, writeBufferSize, arenaBlockSizeConfigured, defaultArenaBlockSize, writeBufferManagerCapacity});
        return false;
    }

    public static void registerKvStateInformation(Map<String, ForStKvStateInfo> kvStateInformation, ForStNativeMetricMonitor nativeMetricMonitor, String columnFamilyName, ForStKvStateInfo registeredColumn) {
        kvStateInformation.put(columnFamilyName, registeredColumn);
        if (nativeMetricMonitor != null) {
            nativeMetricMonitor.registerColumnFamily(columnFamilyName, registeredColumn.columnFamilyHandle);
        }
    }

    private static void throwExceptionIfPathLengthExceededOnWindows(String path, Exception cause) throws IOException {
        int maxWinDirPathLen = 247;
        if (path.length() > 247 && OperatingSystem.isWindows()) {
            throw new IOException(String.format("The directory path length (%d) is longer than the directory path length limit for Windows (%d): %s", path.length(), 247, path), cause);
        }
    }

    public static class ForStKvStateInfo
    implements AutoCloseable {
        public final ColumnFamilyHandle columnFamilyHandle;
        public final RegisteredStateMetaInfoBase metaInfo;

        public ForStKvStateInfo(ColumnFamilyHandle columnFamilyHandle, RegisteredStateMetaInfoBase metaInfo) {
            this.columnFamilyHandle = columnFamilyHandle;
            this.metaInfo = metaInfo;
        }

        @Override
        public void close() throws Exception {
            this.columnFamilyHandle.close();
        }
    }
}

