/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestContainer;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStInnerTable;
import org.apache.flink.state.forst.ForStListState;
import org.apache.flink.state.forst.ForStMapState;
import org.apache.flink.state.forst.ForStStateRequestType;

public class ForStStateRequestClassifier
implements StateRequestContainer {
    private final List<ForStDBGetRequest<?, ?, ?, ?>> dbGetRequests = new ArrayList();
    private final List<ForStDBPutRequest<?, ?, ?>> dbPutRequests = new ArrayList();
    private final List<ForStDBIterRequest<?, ?, ?, ?, ?>> dbIterRequests = new ArrayList();

    public void offer(StateRequest<?, ?, ?, ?> stateRequest) {
        Object forstDbRequest = ForStStateRequestClassifier.convertRequests(stateRequest);
        if (forstDbRequest instanceof ForStDBGetRequest) {
            this.dbGetRequests.add((ForStDBGetRequest)forstDbRequest);
        } else if (forstDbRequest instanceof ForStDBPutRequest) {
            this.dbPutRequests.add((ForStDBPutRequest)forstDbRequest);
        } else {
            this.dbIterRequests.add((ForStDBIterRequest)forstDbRequest);
        }
    }

    public boolean isEmpty() {
        return this.dbGetRequests.isEmpty() && this.dbPutRequests.isEmpty() && this.dbIterRequests.isEmpty();
    }

    public static Object convertRequests(StateRequest<?, ?, ?, ?> stateRequest) {
        StateRequestType stateRequestType = stateRequest.getRequestType();
        switch (stateRequestType) {
            case VALUE_GET: 
            case LIST_GET: 
            case MAP_GET: 
            case MAP_IS_EMPTY: 
            case MAP_CONTAINS: 
            case REDUCING_GET: 
            case AGGREGATING_GET: {
                ForStInnerTable innerTable = (ForStInnerTable)stateRequest.getState();
                return innerTable.buildDBGetRequest(stateRequest);
            }
            case VALUE_UPDATE: 
            case LIST_UPDATE: 
            case LIST_ADD: 
            case LIST_ADD_ALL: 
            case MAP_PUT: 
            case MAP_REMOVE: 
            case REDUCING_ADD: 
            case AGGREGATING_ADD: {
                ForStInnerTable innerTable = (ForStInnerTable)stateRequest.getState();
                return innerTable.buildDBPutRequest(stateRequest);
            }
            case MAP_ITER: 
            case MAP_ITER_KEY: 
            case MAP_ITER_VALUE: 
            case ITERATOR_LOADING: {
                ForStMapState forStMapState = (ForStMapState)stateRequest.getState();
                return forStMapState.buildDBIterRequest(stateRequest);
            }
            case MAP_PUT_ALL: {
                ForStMapState forStMapState = (ForStMapState)stateRequest.getState();
                return forStMapState.buildDBBunchPutRequest(stateRequest);
            }
            case CLEAR: {
                if (stateRequest.getState() instanceof ForStMapState) {
                    ForStMapState forStMapState = (ForStMapState)stateRequest.getState();
                    return forStMapState.buildDBBunchPutRequest(stateRequest);
                }
                if (stateRequest.getState() instanceof ForStInnerTable) {
                    ForStInnerTable innerTable = (ForStInnerTable)stateRequest.getState();
                    return innerTable.buildDBPutRequest(stateRequest);
                }
                throw new UnsupportedOperationException("The State " + stateRequest.getState().getClass() + " doesn't yet support the clear method.");
            }
            case CUSTOMIZED: {
                return ForStStateRequestClassifier.handleCustomizedStateRequests(stateRequest);
            }
        }
        throw new UnsupportedOperationException("Unsupported state request type:" + stateRequestType);
    }

    private static Object handleCustomizedStateRequests(StateRequest<?, ?, ?, ?> stateRequest) {
        Tuple2 payload = (Tuple2)stateRequest.getPayload();
        ForStStateRequestType requestType = (ForStStateRequestType)((Object)payload.f0);
        switch (requestType) {
            case LIST_GET_RAW: {
                ForStListState forStListState = (ForStListState)stateRequest.getState();
                return forStListState.buildDBGetRequest(stateRequest);
            }
            case MERGE_ALL_RAW: {
                ForStListState forStListState = (ForStListState)stateRequest.getState();
                return forStListState.buildDBPutRequest(stateRequest);
            }
        }
        throw new UnsupportedOperationException("Unsupported customized state request type:" + requestType);
    }

    public List<ForStDBGetRequest<?, ?, ?, ?>> pollDbGetRequests() {
        return this.dbGetRequests;
    }

    public List<ForStDBPutRequest<?, ?, ?>> pollDbPutRequests() {
        return this.dbPutRequests;
    }

    public List<ForStDBIterRequest<?, ?, ?, ?, ?>> pollDbIterRequests() {
        return this.dbIterRequests;
    }

    public long size() {
        return this.dbGetRequests.size() + this.dbPutRequests.size() + this.dbIterRequests.size();
    }
}

