/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStInnerTable;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.RocksDB;
import org.forstdb.RocksDBException;

public abstract class ForStDBGetRequest<K, N, V, R> {
    final ContextKey<K, N> key;
    final ForStInnerTable<K, N, V> table;
    final InternalStateFuture<R> future;

    ForStDBGetRequest(ContextKey<K, N> key, ForStInnerTable<K, N, V> table, InternalStateFuture<R> future) {
        this.key = key;
        this.table = table;
        this.future = future;
    }

    public void process(RocksDB db) throws IOException, RocksDBException {
        byte[] key = this.buildSerializedKey();
        byte[] value = db.get(this.getColumnFamilyHandle(), key);
        this.completeStateFuture(value);
    }

    public byte[] buildSerializedKey() throws IOException {
        return this.table.serializeKey(this.key);
    }

    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.table.getColumnFamilyHandle();
    }

    public abstract void completeStateFuture(byte[] var1) throws IOException;

    public void completeStateFutureExceptionally(String message, Throwable ex) {
        this.future.completeExceptionally(message, ex);
    }
}

