/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.state.forst.ForStConfigurableOptions;
import org.apache.flink.state.forst.ForStNativeMetricOptions;
import org.apache.flink.state.forst.ForStOptionsFactory;
import org.apache.flink.state.forst.ForStSharedResources;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.Filter;
import org.rocksdb.FlinkEnv;
import org.rocksdb.IndexType;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.ReadOptions;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForStResourceContainer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ForStResourceContainer.class);
    private static final String FORST_RELOCATE_LOG_SUFFIX = "_LOG";
    private static final int INSTANCE_PATH_LENGTH_LIMIT = 255 - "_LOG".length();
    private static final String DB_DIR_STRING = "db";
    @Nullable
    private final Path remoteBasePath;
    @Nullable
    private final Path remoteForStPath;
    @Nullable
    private final File localBasePath;
    @Nullable
    private final File localForStPath;
    private final ReadableConfig configuration;
    @Nullable
    private final ForStOptionsFactory optionsFactory;
    @Nullable
    private final OpaqueMemoryResource<ForStSharedResources> sharedResources;
    private final boolean enableStatistics;
    private final ArrayList<AutoCloseable> handlesToClose;
    @Nullable
    private java.nio.file.Path relocatedDbLogBaseDir;

    @VisibleForTesting
    public ForStResourceContainer() {
        this((ReadableConfig)new Configuration(), null, null, null, null, false);
    }

    @VisibleForTesting
    public ForStResourceContainer(@Nullable ForStOptionsFactory optionsFactory) {
        this((ReadableConfig)new Configuration(), optionsFactory, null, null, null, false);
    }

    @VisibleForTesting
    public ForStResourceContainer(@Nullable ForStOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<ForStSharedResources> sharedResources) {
        this((ReadableConfig)new Configuration(), optionsFactory, sharedResources, null, null, false);
    }

    public ForStResourceContainer(ReadableConfig configuration, @Nullable ForStOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<ForStSharedResources> sharedResources, @Nullable File localBasePath, @Nullable Path remoteBasePath, boolean enableStatistics) {
        this.configuration = configuration;
        this.optionsFactory = optionsFactory;
        this.sharedResources = sharedResources;
        this.localBasePath = localBasePath;
        this.localForStPath = localBasePath != null ? new File(localBasePath, DB_DIR_STRING) : null;
        this.remoteBasePath = remoteBasePath;
        this.remoteForStPath = remoteBasePath != null ? new Path(remoteBasePath, DB_DIR_STRING) : null;
        this.enableStatistics = enableStatistics;
        this.handlesToClose = new ArrayList();
    }

    public DBOptions getDbOptions() {
        DBOptions opt = this.createBaseCommonDBOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        this.setDBOptionsFromConfigurableOptions(opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createDBOptions(opt, this.handlesToClose);
        }
        opt = opt.setCreateIfMissing(true).setAvoidFlushDuringShutdown(true);
        if (this.sharedResources != null) {
            opt.setWriteBufferManager(((ForStSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManager());
        }
        if (this.enableStatistics) {
            Statistics statistics = new Statistics();
            opt.setStatistics(statistics);
            this.handlesToClose.add((AutoCloseable)statistics);
        }
        if (this.remoteForStPath != null) {
            opt.setEnv((Env)new FlinkEnv(this.remoteForStPath.toString()));
        }
        return opt;
    }

    public ColumnFamilyOptions getColumnOptions() {
        ColumnFamilyOptions opt = this.createBaseCommonColumnOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        this.setColumnFamilyOptionsFromConfigurableOptions(opt, this.handlesToClose);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createColumnOptions(opt, this.handlesToClose);
        }
        if (this.sharedResources != null) {
            BlockBasedTableConfig blockBasedTableConfig;
            ForStSharedResources rocksResources = (ForStSharedResources)this.sharedResources.getResourceHandle();
            Cache blockCache = rocksResources.getCache();
            TableFormatConfig tableFormatConfig = opt.tableFormatConfig();
            if (tableFormatConfig == null) {
                blockBasedTableConfig = new BlockBasedTableConfig();
            } else {
                Preconditions.checkArgument((boolean)(tableFormatConfig instanceof BlockBasedTableConfig), (Object)"We currently only support BlockBasedTableConfig When bounding total memory.");
                blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
            }
            if (rocksResources.isUsingPartitionedIndexFilters() && this.overwriteFilterIfExist(blockBasedTableConfig)) {
                blockBasedTableConfig.setIndexType(IndexType.kTwoLevelIndexSearch);
                blockBasedTableConfig.setPartitionFilters(true);
                blockBasedTableConfig.setPinTopLevelIndexAndFilter(true);
            }
            blockBasedTableConfig.setBlockCache(blockCache);
            blockBasedTableConfig.setCacheIndexAndFilterBlocks(true);
            blockBasedTableConfig.setCacheIndexAndFilterBlocksWithHighPriority(true);
            blockBasedTableConfig.setPinL0FilterAndIndexBlocksInCache(true);
            opt.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
        }
        return opt;
    }

    public WriteOptions getWriteOptions() {
        WriteOptions opt = new WriteOptions().setDisableWAL(true);
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createWriteOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    public ReadOptions getReadOptions() {
        ReadOptions opt = new ReadOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createReadOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    @Nullable
    public File getLocalBasePath() {
        return this.localBasePath;
    }

    @Nullable
    public File getLocalForStPath() {
        return this.localForStPath;
    }

    @Nullable
    public Path getRemoteBasePath() {
        return this.remoteBasePath;
    }

    @Nullable
    public Path getRemoteForStPath() {
        return this.remoteForStPath;
    }

    public void prepareDirectories() throws Exception {
        if (this.remoteBasePath != null && this.remoteForStPath != null) {
            ForStResourceContainer.prepareDirectories(this.remoteBasePath, this.remoteForStPath);
        }
        if (this.localBasePath != null && this.localForStPath != null) {
            ForStResourceContainer.prepareDirectories(new Path(this.localBasePath.getPath()), new Path(this.localForStPath.getPath()));
        }
    }

    private static void prepareDirectories(Path basePath, Path dbPath) throws IOException {
        FileSystem fileSystem = basePath.getFileSystem();
        if (fileSystem.exists(basePath)) {
            if (!fileSystem.getFileStatus(basePath).isDir()) {
                throw new IOException("Not a directory: " + basePath);
            }
        } else if (!fileSystem.mkdirs(basePath)) {
            throw new IOException(String.format("Could not create ForSt directory at %s.", basePath));
        }
        if (fileSystem.exists(dbPath)) {
            fileSystem.delete(dbPath, true);
        }
        if (!fileSystem.mkdirs(dbPath)) {
            throw new IOException(String.format("Could not create ForSt db directory at %s.", dbPath));
        }
    }

    public void clearDirectories() throws Exception {
        if (this.remoteBasePath != null) {
            ForStResourceContainer.clearDirectories(this.remoteBasePath);
        }
        if (this.localBasePath != null) {
            ForStResourceContainer.clearDirectories(new Path(this.localBasePath.getPath()));
        }
    }

    private static void clearDirectories(Path basePath) throws IOException {
        FileSystem fileSystem = basePath.getFileSystem();
        if (fileSystem.exists(basePath)) {
            fileSystem.delete(basePath, true);
        }
    }

    ForStNativeMetricOptions getMemoryWatcherOptions(ForStNativeMetricOptions defaultMetricOptions) {
        return this.optionsFactory == null ? defaultMetricOptions : this.optionsFactory.createNativeMetricsOptions(defaultMetricOptions);
    }

    @Override
    public void close() throws Exception {
        this.handlesToClose.forEach(IOUtils::closeQuietly);
        this.handlesToClose.clear();
        if (this.sharedResources != null) {
            this.sharedResources.close();
        }
        this.cleanRelocatedDbLogs();
    }

    private boolean overwriteFilterIfExist(BlockBasedTableConfig blockBasedTableConfig) {
        if (blockBasedTableConfig.filterPolicy() != null) {
            BloomFilter newFilter = new BloomFilter(10.0, false);
            LOG.info("Existing filter has been overwritten to full filters since partitioned index filters is enabled.");
            blockBasedTableConfig.setFilterPolicy((Filter)newFilter);
            this.handlesToClose.add((AutoCloseable)newFilter);
        }
        return true;
    }

    DBOptions createBaseCommonDBOptions() {
        return new DBOptions().setUseFsync(false).setStatsDumpPeriodSec(0);
    }

    ColumnFamilyOptions createBaseCommonColumnOptions() {
        return new ColumnFamilyOptions();
    }

    @Nullable
    private <T> T internalGetOption(ConfigOption<T> option) {
        return (T)this.configuration.getOptional(option).orElseGet(() -> option.defaultValue());
    }

    private DBOptions setDBOptionsFromConfigurableOptions(DBOptions currentOptions) {
        currentOptions.setMaxBackgroundJobs(this.internalGetOption(ForStConfigurableOptions.MAX_BACKGROUND_THREADS).intValue());
        currentOptions.setMaxOpenFiles(this.internalGetOption(ForStConfigurableOptions.MAX_OPEN_FILES).intValue());
        currentOptions.setInfoLogLevel(this.internalGetOption(ForStConfigurableOptions.LOG_LEVEL));
        String logDir = this.internalGetOption(ForStConfigurableOptions.LOG_DIR);
        if (logDir == null || logDir.isEmpty()) {
            if (this.localForStPath == null || this.localForStPath.getAbsolutePath().length() <= INSTANCE_PATH_LENGTH_LIMIT) {
                this.relocateDefaultDbLogDir(currentOptions);
            } else {
                LOG.warn("ForSt local path length exceeds limit : {}, disable log relocate.", (Object)this.localForStPath);
            }
        } else {
            currentOptions.setDbLogDir(logDir);
        }
        currentOptions.setMaxLogFileSize(this.internalGetOption(ForStConfigurableOptions.LOG_MAX_FILE_SIZE).getBytes());
        currentOptions.setKeepLogFileNum((long)this.internalGetOption(ForStConfigurableOptions.LOG_FILE_NUM).intValue());
        return currentOptions;
    }

    private ColumnFamilyOptions setColumnFamilyOptionsFromConfigurableOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
        BlockBasedTableConfig blockBasedTableConfig;
        currentOptions.setCompactionStyle(this.internalGetOption(ForStConfigurableOptions.COMPACTION_STYLE));
        currentOptions.setCompressionPerLevel(this.internalGetOption(ForStConfigurableOptions.COMPRESSION_PER_LEVEL));
        currentOptions.setLevelCompactionDynamicLevelBytes(this.internalGetOption(ForStConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE).booleanValue());
        currentOptions.setTargetFileSizeBase(this.internalGetOption(ForStConfigurableOptions.TARGET_FILE_SIZE_BASE).getBytes());
        currentOptions.setMaxBytesForLevelBase(this.internalGetOption(ForStConfigurableOptions.MAX_SIZE_LEVEL_BASE).getBytes());
        currentOptions.setWriteBufferSize(this.internalGetOption(ForStConfigurableOptions.WRITE_BUFFER_SIZE).getBytes());
        currentOptions.setMaxWriteBufferNumber(this.internalGetOption(ForStConfigurableOptions.MAX_WRITE_BUFFER_NUMBER).intValue());
        currentOptions.setMinWriteBufferNumberToMerge(this.internalGetOption(ForStConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE).intValue());
        TableFormatConfig tableFormatConfig = currentOptions.tableFormatConfig();
        if (tableFormatConfig == null) {
            blockBasedTableConfig = new BlockBasedTableConfig();
        } else {
            if (tableFormatConfig instanceof PlainTableConfig) {
                return currentOptions;
            }
            blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
        }
        blockBasedTableConfig.setBlockSize(this.internalGetOption(ForStConfigurableOptions.BLOCK_SIZE).getBytes());
        blockBasedTableConfig.setMetadataBlockSize(this.internalGetOption(ForStConfigurableOptions.METADATA_BLOCK_SIZE).getBytes());
        blockBasedTableConfig.setBlockCacheSize(this.internalGetOption(ForStConfigurableOptions.BLOCK_CACHE_SIZE).getBytes());
        if (this.internalGetOption(ForStConfigurableOptions.USE_BLOOM_FILTER).booleanValue()) {
            double bitsPerKey = this.internalGetOption(ForStConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY);
            boolean blockBasedMode = this.internalGetOption(ForStConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE);
            BloomFilter bloomFilter = new BloomFilter(bitsPerKey, blockBasedMode);
            handlesToClose.add((AutoCloseable)bloomFilter);
            blockBasedTableConfig.setFilterPolicy((Filter)bloomFilter);
        }
        return currentOptions.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
    }

    private void relocateDefaultDbLogDir(DBOptions dbOptions) {
        String logFilePath = System.getProperty("log.file");
        if (logFilePath != null) {
            File logFile = this.resolveFileLocation(logFilePath);
            if (logFile != null && this.resolveFileLocation(logFile.getParent()) != null) {
                String relocatedDbLogDir = logFile.getParent();
                this.relocatedDbLogBaseDir = new File(relocatedDbLogDir).toPath();
                dbOptions.setDbLogDir(relocatedDbLogDir);
            } else {
                this.setLocalForStPathAsLogDir(dbOptions);
            }
        } else {
            this.setLocalForStPathAsLogDir(dbOptions);
        }
    }

    private void setLocalForStPathAsLogDir(DBOptions dbOptions) {
        if (this.localForStPath != null) {
            this.relocatedDbLogBaseDir = this.localForStPath.toPath();
            dbOptions.setDbLogDir(this.localForStPath.getPath());
        }
    }

    private File resolveFileLocation(String logFilePath) {
        File logFile = new File(logFilePath);
        return logFile.exists() && logFile.canRead() ? logFile : null;
    }

    private void cleanRelocatedDbLogs() {
        if (this.localForStPath != null && this.relocatedDbLogBaseDir != null) {
            LOG.info("Cleaning up relocated ForSt logs: {}.", (Object)this.relocatedDbLogBaseDir);
            String relocatedDbLogPrefix = this.resolveRelocatedDbLogPrefix(this.localForStPath.getAbsolutePath());
            try {
                Arrays.stream(FileUtils.listDirectory((java.nio.file.Path)this.relocatedDbLogBaseDir)).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.toFile().getName().startsWith(relocatedDbLogPrefix)).forEach(IOUtils::deleteFileQuietly);
            }
            catch (IOException e) {
                LOG.warn("Could not list relocated ForSt log directory: {}", (Object)this.relocatedDbLogBaseDir);
            }
        }
    }

    private String resolveRelocatedDbLogPrefix(String instanceForStAbsolutePath) {
        if (!instanceForStAbsolutePath.isEmpty() && !instanceForStAbsolutePath.matches("^[a-zA-Z0-9\\-._].*")) {
            instanceForStAbsolutePath = instanceForStAbsolutePath.substring(1);
        }
        return instanceForStAbsolutePath.replaceAll("[^a-zA-Z0-9\\-._]", "_") + FORST_RELOCATE_LOG_SUFFIX;
    }
}

