/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.File;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.runtime.state.StateBackendBuilder;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.state.forst.ForStKeyedStateBackend;
import org.apache.flink.state.forst.ForStNativeMetricMonitor;
import org.apache.flink.state.forst.ForStNativeMetricOptions;
import org.apache.flink.state.forst.ForStResourceContainer;
import org.apache.flink.state.forst.restore.ForStNoneRestoreOperation;
import org.apache.flink.state.forst.restore.ForStRestoreOperation;
import org.apache.flink.state.forst.restore.ForStRestoreResult;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForStKeyedStateBackendBuilder<K>
implements StateBackendBuilder<ForStKeyedStateBackend<K>, BackendBuildingException> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int KEY_SERIALIZER_BUFFER_START_SIZE = 32;
    private static final int VALUE_SERIALIZER_BUFFER_START_SIZE = 128;
    private final StateSerializerProvider<K> keySerializerProvider;
    private final int numberOfKeyGroups;
    private final Collection<KeyedStateHandle> restoreStateHandles;
    private final Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory;
    private final ForStResourceContainer optionsContainer;
    private final MetricGroup metricGroup;
    private ForStNativeMetricOptions nativeMetricOptions;

    public ForStKeyedStateBackendBuilder(ForStResourceContainer optionsContainer, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, TypeSerializer<K> keySerializer, int numberOfKeyGroups, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles) {
        this.optionsContainer = optionsContainer;
        this.columnFamilyOptionsFactory = (Function)Preconditions.checkNotNull(columnFamilyOptionsFactory);
        this.keySerializerProvider = StateSerializerProvider.fromNewRegisteredSerializer(keySerializer);
        this.numberOfKeyGroups = numberOfKeyGroups;
        this.metricGroup = metricGroup;
        this.restoreStateHandles = stateHandles;
        this.nativeMetricOptions = new ForStNativeMetricOptions();
    }

    ForStKeyedStateBackendBuilder<K> setNativeMetricOptions(ForStNativeMetricOptions nativeMetricOptions) {
        this.nativeMetricOptions = nativeMetricOptions;
        return this;
    }

    public ForStKeyedStateBackend<K> build() throws BackendBuildingException {
        ColumnFamilyHandle defaultColumnFamilyHandle = null;
        ForStNativeMetricMonitor nativeMetricMonitor = null;
        RocksDB db = null;
        ForStRestoreOperation restoreOperation = null;
        int keyGroupPrefixBytes = CompositeKeySerializationUtils.computeRequiredBytesInKeyGroupPrefix((int)this.numberOfKeyGroups);
        Supplier serializedKeyBuilder = () -> new SerializedCompositeKeyBuilder(this.keySerializerProvider.currentSchemaSerializer().duplicate(), keyGroupPrefixBytes, 32);
        Supplier<DataOutputSerializer> valueSerializerView = () -> new DataOutputSerializer(128);
        Supplier<DataInputDeserializer> valueDeserializerView = DataInputDeserializer::new;
        try {
            this.optionsContainer.prepareDirectories();
            restoreOperation = this.getForStRestoreOperation();
            ForStRestoreResult restoreResult = restoreOperation.restore();
            db = restoreResult.getDb();
            defaultColumnFamilyHandle = restoreResult.getDefaultColumnFamilyHandle();
            nativeMetricMonitor = restoreResult.getNativeMetricMonitor();
        }
        catch (Throwable e) {
            IOUtils.closeQuietly(defaultColumnFamilyHandle);
            IOUtils.closeQuietly(nativeMetricMonitor);
            IOUtils.closeQuietly(db);
            IOUtils.closeQuietly((AutoCloseable)restoreOperation);
            try {
                this.optionsContainer.clearDirectories();
            }
            catch (Exception ex) {
                this.logger.warn("Failed to delete ForSt local base path {}, remote base path {}.", new Object[]{this.optionsContainer.getLocalBasePath(), this.optionsContainer.getRemoteBasePath(), ex});
            }
            IOUtils.closeQuietly((AutoCloseable)this.optionsContainer);
            if (e instanceof BackendBuildingException) {
                throw (BackendBuildingException)e;
            }
            String errMsg = "Caught unexpected exception.";
            this.logger.error(errMsg, e);
            throw new BackendBuildingException(errMsg, e);
        }
        this.logger.info("Finished building ForSt keyed state-backend at local base path: {}, remote base path: {}.", (Object)this.optionsContainer.getLocalBasePath(), (Object)this.optionsContainer.getRemoteBasePath());
        return new ForStKeyedStateBackend(this.optionsContainer, this.keySerializerProvider.currentSchemaSerializer(), serializedKeyBuilder, valueSerializerView, valueDeserializerView, db, this.columnFamilyOptionsFactory, defaultColumnFamilyHandle, nativeMetricMonitor);
    }

    private ForStRestoreOperation getForStRestoreOperation() {
        File instanceForStPath;
        File file = instanceForStPath = this.optionsContainer.getRemoteForStPath() == null ? this.optionsContainer.getLocalForStPath() : new File("/");
        if (CollectionUtil.isEmptyOrAllElementsNull(this.restoreStateHandles)) {
            return new ForStNoneRestoreOperation(instanceForStPath, this.optionsContainer.getDbOptions(), this.columnFamilyOptionsFactory, this.nativeMetricOptions, this.metricGroup);
        }
        throw new UnsupportedOperationException("Not support restoring yet for ForStStateBackend");
    }
}

