/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.util.function.FunctionWithException;

@ThreadSafe
public class ContextKey<K> {
    private final RecordContext<K> recordContext;

    public ContextKey(RecordContext<K> recordContext) {
        this.recordContext = recordContext;
    }

    public K getRawKey() {
        return (K)this.recordContext.getKey();
    }

    public int getKeyGroup() {
        return this.recordContext.getKeyGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getOrCreateSerializedKey(FunctionWithException<ContextKey<K>, byte[], IOException> serializeKeyFunc) throws IOException {
        if (this.recordContext.getExtra() != null) {
            return (byte[])this.recordContext.getExtra();
        }
        RecordContext<K> recordContext = this.recordContext;
        synchronized (recordContext) {
            if (this.recordContext.getExtra() == null) {
                byte[] serializedKey = (byte[])serializeKeyFunc.apply((Object)this);
                this.recordContext.setExtra((Object)serializedKey);
            }
        }
        return (byte[])this.recordContext.getExtra();
    }

    public int hashCode() {
        return Objects.hash(this.recordContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextKey that = (ContextKey)o;
        return Objects.equals(this.recordContext, that.recordContext);
    }
}

