/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.state.forst.ForStInnerTable;
import org.rocksdb.ColumnFamilyHandle;

public class ForStDBGetRequest<K, V> {
    private final K key;
    private final ForStInnerTable<K, V> table;
    private final InternalStateFuture<V> future;

    private ForStDBGetRequest(K key, ForStInnerTable<K, V> table, InternalStateFuture<V> future) {
        this.key = key;
        this.table = table;
        this.future = future;
    }

    public byte[] buildSerializedKey() throws IOException {
        return this.table.serializeKey(this.key);
    }

    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.table.getColumnFamilyHandle();
    }

    public void completeStateFuture(byte[] bytesValue) throws IOException {
        if (bytesValue == null) {
            this.future.complete(null);
            return;
        }
        V value = this.table.deserializeValue(bytesValue);
        this.future.complete(value);
    }

    public void completeStateFutureExceptionally(String message, Throwable ex) {
        this.future.completeExceptionally(message, ex);
    }

    static <K, V> ForStDBGetRequest<K, V> of(K key, ForStInnerTable<K, V> table, InternalStateFuture<V> future) {
        return new ForStDBGetRequest<K, V>(key, table, future);
    }
}

