/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.formats.protobuf.shaded.com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.table.types.logical.LogicalType;

public class PbCodegenArrayDeserializer
implements PbCodegenDeserializer {
    private final Descriptors.FieldDescriptor fd;
    private final LogicalType elementType;
    private final PbFormatContext formatContext;

    public PbCodegenArrayDeserializer(Descriptors.FieldDescriptor fd, LogicalType elementType, PbFormatContext formatContext) {
        this.fd = fd;
        this.elementType = elementType;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String pbObjectCode, int indent) throws PbCodegenException {
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        String protoTypeStr = PbCodegenUtils.getTypeStrFromProto(this.fd, false);
        String listPbVar = "list" + uid;
        String flinkArrVar = "newArr" + uid;
        String flinkArrEleVar = "subReturnVar" + uid;
        String iVar = "i" + uid;
        String subPbObjVar = "subObj" + uid;
        appender.appendLine("List<" + protoTypeStr + "> " + listPbVar + "=" + pbObjectCode);
        appender.appendLine("Object[] " + flinkArrVar + "= new Object[" + listPbVar + ".size()]");
        appender.begin("for(int " + iVar + "=0;" + iVar + " < " + listPbVar + ".size(); " + iVar + "++){");
        appender.appendLine("Object " + flinkArrEleVar + " = null");
        appender.appendLine(protoTypeStr + " " + subPbObjVar + " = (" + protoTypeStr + ")" + listPbVar + ".get(" + iVar + ")");
        PbCodegenDeserializer codegenDes = PbCodegenDeserializeFactory.getPbCodegenDes(this.fd, this.elementType, this.formatContext);
        String code = codegenDes.codegen(flinkArrEleVar, subPbObjVar, appender.currentIndent());
        appender.appendSegment(code);
        appender.appendLine(flinkArrVar + "[" + iVar + "]=" + flinkArrEleVar);
        appender.end("}");
        appender.appendLine(resultVar + " = new GenericArrayData(" + flinkArrVar + ")");
        return appender.code();
    }
}

