/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.util;

import org.apache.flink.formats.protobuf.shaded.com.google.protobuf.Descriptors;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;

public class PbToRowTypeUtil {
    public static RowType generateRowType(Descriptors.Descriptor root) {
        return PbToRowTypeUtil.generateRowType(root, false);
    }

    public static RowType generateRowType(Descriptors.Descriptor root, boolean enumAsInt) {
        int size = root.getFields().size();
        LogicalType[] types = new LogicalType[size];
        String[] rowFieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            Descriptors.FieldDescriptor field = root.getFields().get(i);
            rowFieldNames[i] = field.getName();
            types[i] = PbToRowTypeUtil.generateFieldTypeInformation(field, enumAsInt);
        }
        return RowType.of((LogicalType[])types, (String[])rowFieldNames);
    }

    private static LogicalType generateFieldTypeInformation(Descriptors.FieldDescriptor field, boolean enumAsInt) {
        Object type;
        Descriptors.FieldDescriptor.JavaType fieldType = field.getJavaType();
        if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
            if (field.isMapField()) {
                MapType mapType = new MapType(PbToRowTypeUtil.generateFieldTypeInformation(field.getMessageType().findFieldByName("key"), enumAsInt), PbToRowTypeUtil.generateFieldTypeInformation(field.getMessageType().findFieldByName("value"), enumAsInt));
                return mapType;
            }
            if (field.isRepeated()) {
                return new ArrayType((LogicalType)PbToRowTypeUtil.generateRowType(field.getMessageType()));
            }
            return PbToRowTypeUtil.generateRowType(field.getMessageType());
        }
        if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.STRING)) {
            type = new VarCharType(Integer.MAX_VALUE);
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.LONG)) {
            type = new BigIntType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.BOOLEAN)) {
            type = new BooleanType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.INT)) {
            type = new IntType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.DOUBLE)) {
            type = new DoubleType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.FLOAT)) {
            type = new FloatType();
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
            type = enumAsInt ? new IntType() : new VarCharType(Integer.MAX_VALUE);
        } else if (fieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
            type = new VarBinaryType(Integer.MAX_VALUE);
        } else {
            throw new ValidationException("unsupported field type: " + String.valueOf((Object)fieldType));
        }
        if (field.isRepeated()) {
            return new ArrayType((LogicalType)type);
        }
        return type;
    }
}

