/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.formats.protobuf.PbFormatOptions;

public class PbFormatConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String messageClassName;
    private final boolean ignoreParseErrors;
    private final boolean readDefaultValues;
    private final String writeNullStringLiterals;

    public PbFormatConfig(String messageClassName, boolean ignoreParseErrors, boolean readDefaultValues, String writeNullStringLiterals) {
        this.messageClassName = messageClassName;
        this.ignoreParseErrors = ignoreParseErrors;
        this.readDefaultValues = readDefaultValues;
        this.writeNullStringLiterals = writeNullStringLiterals;
    }

    public String getMessageClassName() {
        return this.messageClassName;
    }

    public boolean isIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public boolean isReadDefaultValues() {
        return this.readDefaultValues;
    }

    public String getWriteNullStringLiterals() {
        return this.writeNullStringLiterals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PbFormatConfig that = (PbFormatConfig)o;
        return this.ignoreParseErrors == that.ignoreParseErrors && this.readDefaultValues == that.readDefaultValues && Objects.equals(this.messageClassName, that.messageClassName) && Objects.equals(this.writeNullStringLiterals, that.writeNullStringLiterals);
    }

    public int hashCode() {
        return Objects.hash(this.messageClassName, this.ignoreParseErrors, this.readDefaultValues, this.writeNullStringLiterals);
    }

    public static class PbFormatConfigBuilder {
        private String messageClassName;
        private boolean ignoreParseErrors = (Boolean)PbFormatOptions.IGNORE_PARSE_ERRORS.defaultValue();
        private boolean readDefaultValues = (Boolean)PbFormatOptions.READ_DEFAULT_VALUES.defaultValue();
        private String writeNullStringLiterals = (String)PbFormatOptions.WRITE_NULL_STRING_LITERAL.defaultValue();

        public PbFormatConfigBuilder messageClassName(String messageClassName) {
            this.messageClassName = messageClassName;
            return this;
        }

        public PbFormatConfigBuilder ignoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public PbFormatConfigBuilder readDefaultValues(boolean readDefaultValues) {
            this.readDefaultValues = readDefaultValues;
            return this;
        }

        public PbFormatConfigBuilder writeNullStringLiterals(String writeNullStringLiterals) {
            this.writeNullStringLiterals = writeNullStringLiterals;
            return this;
        }

        public PbFormatConfig build() {
            return new PbFormatConfig(this.messageClassName, this.ignoreParseErrors, this.readDefaultValues, this.writeNullStringLiterals);
        }
    }
}

