/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum SqlTypeFamily implements RelDataTypeFamily
{
    CHARACTER,
    BINARY,
    NUMERIC,
    DATE,
    TIME,
    TIMESTAMP,
    BOOLEAN,
    INTERVAL_YEAR_MONTH,
    INTERVAL_DAY_TIME,
    STRING,
    APPROXIMATE_NUMERIC,
    EXACT_NUMERIC,
    DECIMAL,
    INTEGER,
    DATETIME,
    DATETIME_INTERVAL,
    MULTISET,
    ARRAY,
    MAP,
    NULL,
    ANY,
    CURSOR,
    COLUMN_LIST,
    GEO,
    VARIANT,
    IGNORE;

    private static final Map<Integer, SqlTypeFamily> JDBC_TYPE_TO_FAMILY;

    public static @Nullable SqlTypeFamily getFamilyForJdbcType(int jdbcType) {
        return JDBC_TYPE_TO_FAMILY.get(jdbcType);
    }

    public List<SqlTypeFamily> allowableDifferenceTypes() {
        switch (this) {
            case NUMERIC: {
                return ImmutableList.of((Object)((Object)NUMERIC));
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return ImmutableList.of((Object)((Object)INTERVAL_DAY_TIME), (Object)((Object)INTERVAL_YEAR_MONTH));
            }
        }
        return ImmutableList.of();
    }

    public Collection<SqlTypeName> getTypeNames() {
        switch (this) {
            case CHARACTER: {
                return SqlTypeName.CHAR_TYPES;
            }
            case BINARY: {
                return SqlTypeName.BINARY_TYPES;
            }
            case NUMERIC: {
                return SqlTypeName.NUMERIC_TYPES;
            }
            case DECIMAL: {
                return ImmutableList.of((Object)((Object)SqlTypeName.DECIMAL));
            }
            case DATE: {
                return ImmutableList.of((Object)((Object)SqlTypeName.DATE));
            }
            case TIME: {
                return ImmutableList.of((Object)((Object)SqlTypeName.TIME), (Object)((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE));
            }
            case TIMESTAMP: {
                return ImmutableList.of((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
            }
            case BOOLEAN: {
                return SqlTypeName.BOOLEAN_TYPES;
            }
            case INTERVAL_YEAR_MONTH: {
                return SqlTypeName.YEAR_INTERVAL_TYPES;
            }
            case INTERVAL_DAY_TIME: {
                return SqlTypeName.DAY_INTERVAL_TYPES;
            }
            case STRING: {
                return SqlTypeName.STRING_TYPES;
            }
            case APPROXIMATE_NUMERIC: {
                return SqlTypeName.APPROX_TYPES;
            }
            case EXACT_NUMERIC: {
                return SqlTypeName.EXACT_TYPES;
            }
            case INTEGER: {
                return SqlTypeName.INT_TYPES;
            }
            case DATETIME: {
                return SqlTypeName.DATETIME_TYPES;
            }
            case DATETIME_INTERVAL: {
                return SqlTypeName.INTERVAL_TYPES;
            }
            case GEO: {
                return SqlTypeName.GEOMETRY_TYPES;
            }
            case MULTISET: {
                return ImmutableList.of((Object)((Object)SqlTypeName.MULTISET));
            }
            case ARRAY: {
                return ImmutableList.of((Object)((Object)SqlTypeName.ARRAY));
            }
            case MAP: {
                return ImmutableList.of((Object)((Object)SqlTypeName.MAP));
            }
            case NULL: {
                return ImmutableList.of((Object)((Object)SqlTypeName.NULL));
            }
            case ANY: {
                return SqlTypeName.ALL_TYPES;
            }
            case CURSOR: {
                return ImmutableList.of((Object)((Object)SqlTypeName.CURSOR));
            }
            case COLUMN_LIST: {
                return ImmutableList.of((Object)((Object)SqlTypeName.COLUMN_LIST));
            }
            case VARIANT: {
                return ImmutableList.of((Object)((Object)SqlTypeName.VARIANT));
            }
        }
        throw new IllegalArgumentException();
    }

    public @Nullable RelDataType getDefaultConcreteType(RelDataTypeFactory factory) {
        switch (this) {
            case CHARACTER: {
                return factory.createSqlType(SqlTypeName.VARCHAR);
            }
            case BINARY: {
                return factory.createSqlType(SqlTypeName.VARBINARY);
            }
            case NUMERIC: {
                return SqlTypeUtil.getMaxPrecisionScaleDecimal((RelDataTypeFactory)factory);
            }
            case DATE: {
                return factory.createSqlType(SqlTypeName.DATE);
            }
            case TIME: {
                return factory.createSqlType(SqlTypeName.TIME);
            }
            case TIMESTAMP: {
                return factory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case BOOLEAN: {
                return factory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case STRING: {
                return factory.createSqlType(SqlTypeName.VARCHAR);
            }
            case APPROXIMATE_NUMERIC: {
                return factory.createSqlType(SqlTypeName.DOUBLE);
            }
            case EXACT_NUMERIC: {
                return SqlTypeUtil.getMaxPrecisionScaleDecimal((RelDataTypeFactory)factory);
            }
            case INTEGER: {
                return factory.createSqlType(SqlTypeName.BIGINT);
            }
            case DECIMAL: {
                return factory.createSqlType(SqlTypeName.DECIMAL);
            }
            case DATETIME: {
                return factory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case INTERVAL_DAY_TIME: {
                return factory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO));
            }
            case INTERVAL_YEAR_MONTH: {
                return factory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO));
            }
            case GEO: {
                return factory.createSqlType(SqlTypeName.GEOMETRY);
            }
            case MULTISET: {
                return factory.createMultisetType(factory.createSqlType(SqlTypeName.ANY), -1L);
            }
            case ARRAY: {
                return factory.createArrayType(factory.createSqlType(SqlTypeName.ANY), -1L);
            }
            case MAP: {
                return factory.createMapType(factory.createSqlType(SqlTypeName.ANY), factory.createSqlType(SqlTypeName.ANY));
            }
            case NULL: {
                return factory.createSqlType(SqlTypeName.NULL);
            }
            case CURSOR: {
                return factory.createSqlType(SqlTypeName.CURSOR);
            }
            case COLUMN_LIST: {
                return factory.createSqlType(SqlTypeName.COLUMN_LIST);
            }
        }
        return null;
    }

    public boolean contains(RelDataType type) {
        return SqlTypeUtil.isOfSameTypeName(this.getTypeNames(), (RelDataType)type);
    }

    static {
        JDBC_TYPE_TO_FAMILY = ImmutableMap.builder().put((Object)-7, (Object)NUMERIC).put((Object)-6, (Object)NUMERIC).put((Object)5, (Object)NUMERIC).put((Object)-5, (Object)NUMERIC).put((Object)4, (Object)NUMERIC).put((Object)2, (Object)NUMERIC).put((Object)3, (Object)NUMERIC).put((Object)6, (Object)NUMERIC).put((Object)7, (Object)NUMERIC).put((Object)8, (Object)NUMERIC).put((Object)1, (Object)CHARACTER).put((Object)12, (Object)CHARACTER).put((Object)-1, (Object)CHARACTER).put((Object)2005, (Object)CHARACTER).put((Object)-2, (Object)BINARY).put((Object)-3, (Object)BINARY).put((Object)-4, (Object)BINARY).put((Object)2004, (Object)BINARY).put((Object)91, (Object)DATE).put((Object)92, (Object)TIME).put((Object)2013, (Object)TIME).put((Object)93, (Object)TIMESTAMP).put((Object)2014, (Object)TIMESTAMP).put((Object)16, (Object)BOOLEAN).put((Object)2012, (Object)CURSOR).put((Object)2003, (Object)ARRAY).put((Object)2000, (Object)VARIANT).build();
    }
}

