/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlDescribeCatalog
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DESCRIBE CATALOG", SqlKind.OTHER_DDL);
    private final SqlIdentifier catalogName;
    private final boolean isExtended;

    public SqlDescribeCatalog(SqlParserPos pos, SqlIdentifier catalogName, boolean isExtended) {
        super(pos);
        this.catalogName = catalogName;
        this.isExtended = isExtended;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.catalogName);
    }

    public String getCatalogName() {
        return this.catalogName.getSimple();
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DESCRIBE CATALOG");
        if (this.isExtended) {
            writer.keyword("EXTENDED");
        }
        this.catalogName.unparse(writer, leftPrec, rightPrec);
    }
}

