/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.SqlPartitionSpecProperty;

public class SqlAnalyzeTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ANALYZE TABLE", SqlKind.OTHER_DDL);
    private final SqlIdentifier tableName;
    private final SqlNodeList partitions;
    private final SqlNodeList columns;
    private final boolean allColumns;

    public SqlAnalyzeTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partitions, SqlNodeList columns, boolean allColumns) {
        super(pos);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.allColumns = allColumns;
    }

    public String[] fullTableName() {
        return (String[])this.tableName.names.toArray((Object[])new String[0]);
    }

    public LinkedHashMap<String, String> getPartitions() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (SqlNode node : this.partitions.getList()) {
            Comparable comparable;
            SqlPartitionSpecProperty property = (SqlPartitionSpecProperty)node;
            String value = property.getValue() == null ? null : ((comparable = SqlLiteral.value((SqlNode)property.getValue())) instanceof NlsString ? ((NlsString)comparable).getValue() : comparable.toString());
            ret.put(property.getKey().getSimple(), value);
        }
        return ret;
    }

    public String[] getColumnNames() {
        return (String[])this.columns.getList().stream().map(col -> ((SqlIdentifier)col).getSimple()).toArray(String[]::new);
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableName, (Object)this.partitions, (Object)this.columns);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ANALYZE TABLE");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.tableName.unparse(writer, opLeft, opRight);
        if (this.partitions.size() > 0) {
            writer.keyword("PARTITION");
            this.partitions.unparse(writer, opLeft, opRight);
        }
        writer.keyword("COMPUTE STATISTICS");
        if (this.allColumns) {
            writer.keyword("FOR ALL COLUMNS");
        } else if (this.columns.size() > 0) {
            writer.keyword("FOR COLUMNS");
            this.columns.unparse(writer, 0, 0);
        }
    }
}

