/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterCatalog;
import org.apache.flink.sql.parser.ddl.SqlTableOption;

public class SqlAlterCatalogOptions
extends SqlAlterCatalog {
    private final SqlNodeList propertyList;

    public SqlAlterCatalogOptions(SqlParserPos position, SqlIdentifier catalogName, SqlNodeList propertyList) {
        super(position, catalogName);
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList cannot be null");
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.catalogName, (Object)this.propertyList);
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public Map<String, String> getProperties() {
        return this.propertyList.stream().map(p -> (SqlTableOption)((Object)p)).collect(Collectors.toMap(SqlTableOption::getKeyString, SqlTableOption::getValueString, (option1, option2) -> option2));
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.propertyList) {
            SqlUnparseUtils.printIndent(writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

