/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.apache.flink.table.jdbc.DriverInfo;
import org.apache.flink.table.jdbc.DriverUri;
import org.apache.flink.table.jdbc.FlinkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkDriver
implements Driver {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkDriver.class);

    @Override
    public Connection connect(String url, Properties driverProperties) throws SQLException {
        return new FlinkConnection(DriverUri.create(url, driverProperties));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return DriverUri.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return DriverInfo.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DriverInfo.DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("FlinkDriver#getParentLogger is not supported yet.");
    }

    static {
        try {
            DriverManager.registerDriver(new FlinkDriver());
        }
        catch (SQLException e) {
            LOG.error("Failed to register flink driver", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

