/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;

@Public
public class LongValue
implements NormalizableKey<LongValue>,
ResettableValue<LongValue>,
CopyableValue<LongValue> {
    private static final long serialVersionUID = 1L;
    private long value;

    public LongValue() {
        this.value = 0L;
    }

    public LongValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public void setValue(LongValue value) {
        this.value = value.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public int compareTo(LongValue o) {
        long other = o.value;
        return this.value < other ? -1 : (this.value > other ? 1 : 0);
    }

    public int hashCode() {
        return 43 + (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongValue) {
            return ((LongValue)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 8;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        block5: {
            block4: {
                if (len != 8) break block4;
                target.putLongBigEndian(offset, this.value - Long.MIN_VALUE);
                break block5;
            }
            if (len <= 0) break block5;
            if (len < 8) {
                long value = this.value - Long.MIN_VALUE;
                int i = 0;
                while (len > 0) {
                    target.put(offset + i, (byte)(value >>> (7 - i << 3)));
                    --len;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, this.value - Long.MIN_VALUE);
                for (int i = 8; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    @Override
    public int getBinaryLength() {
        return 8;
    }

    @Override
    public void copyTo(LongValue target) {
        target.value = this.value;
    }

    @Override
    public LongValue copy() {
        return new LongValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 8);
    }
}

