/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;

@Public
public class ByteValue
implements NormalizableKey<ByteValue>,
ResettableValue<ByteValue>,
CopyableValue<ByteValue> {
    private static final long serialVersionUID = 1L;
    private byte value;

    public ByteValue() {
        this.value = 0;
    }

    public ByteValue(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte value) {
        this.value = value;
    }

    @Override
    public void setValue(ByteValue value) {
        this.value = value.value;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readByte();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeByte(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(ByteValue o) {
        byte other = o.value;
        return this.value < other ? -1 : (this.value > other ? 1 : 0);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteValue) {
            return ((ByteValue)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 1;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        if (len == 1) {
            int highByte = this.value & 0xFF;
            target.put(offset, (byte)(highByte += 128));
        } else if (len > 1) {
            int highByte = this.value & 0xFF;
            target.put(offset, (byte)(highByte += 128));
            for (int i = 1; i < len; ++i) {
                target.put(offset + i, (byte)0);
            }
        }
    }

    @Override
    public int getBinaryLength() {
        return 1;
    }

    @Override
    public void copyTo(ByteValue target) {
        target.value = this.value;
    }

    @Override
    public ByteValue copy() {
        return new ByteValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 1);
    }
}

