/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.lookups;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public class FieldReferenceLookup {
    private final List<Map<String, FieldReference>> fieldReferences;

    public FieldReferenceLookup(List<QueryOperation> queryOperations) {
        this.fieldReferences = FieldReferenceLookup.prepareFieldReferences(queryOperations);
    }

    public Optional<FieldReferenceExpression> lookupField(String name) {
        List matchingFields = this.fieldReferences.stream().map(input -> (FieldReference)input.get(name)).filter(Objects::nonNull).collect(Collectors.toList());
        if (matchingFields.size() == 1) {
            return Optional.of(((FieldReference)matchingFields.get(0)).toExpr());
        }
        if (matchingFields.size() == 0) {
            return Optional.empty();
        }
        throw FieldReferenceLookup.failAmbiguousColumn(name);
    }

    public List<FieldReferenceExpression> getAllInputFields() {
        return this.getInputFields(Collections.emptyList());
    }

    public List<FieldReferenceExpression> getInputFields(List<TableConfigOptions.ColumnExpansionStrategy> expansionStrategies) {
        return this.fieldReferences.stream().flatMap(input -> input.values().stream()).filter(fieldRef -> FieldReferenceLookup.includeExpandedColumn(fieldRef.column, expansionStrategies)).map(FieldReference::toExpr).collect(Collectors.toList());
    }

    private static List<Map<String, FieldReference>> prepareFieldReferences(List<QueryOperation> queryOperations) {
        return IntStream.range(0, queryOperations.size()).mapToObj(idx -> FieldReferenceLookup.prepareFieldsInInput((QueryOperation)queryOperations.get(idx), idx)).collect(Collectors.toList());
    }

    private static Map<String, FieldReference> prepareFieldsInInput(QueryOperation input, int inputIdx) {
        ResolvedSchema resolvedSchema = input.getResolvedSchema();
        return IntStream.range(0, resolvedSchema.getColumnCount()).mapToObj(i -> new FieldReference(resolvedSchema.getColumns().get(i), inputIdx, i)).collect(Collectors.toMap(fieldRef -> fieldRef.column.getName(), Function.identity(), (fieldRef1, fieldRef2) -> {
            throw FieldReferenceLookup.failAmbiguousColumn(fieldRef1.column.getName());
        }, LinkedHashMap::new));
    }

    private static ValidationException failAmbiguousColumn(String name) {
        return new ValidationException("Ambiguous column name: " + name);
    }

    public static boolean includeExpandedColumn(Column column, List<TableConfigOptions.ColumnExpansionStrategy> strategies) {
        block4: for (TableConfigOptions.ColumnExpansionStrategy strategy : strategies) {
            switch (strategy) {
                case EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS: {
                    if (!FieldReferenceLookup.isAliasedVirtualMetadataColumn(column)) continue block4;
                    return false;
                }
                case EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS: {
                    if (!FieldReferenceLookup.isDefaultVirtualMetadataColumn(column)) continue block4;
                    return false;
                }
            }
            throw new UnsupportedOperationException("Unknown column expansion strategy: " + String.valueOf(strategy));
        }
        return true;
    }

    private static boolean isAliasedVirtualMetadataColumn(Column column) {
        if (!(column instanceof Column.MetadataColumn)) {
            return false;
        }
        Column.MetadataColumn metadataColumn = (Column.MetadataColumn)column;
        return metadataColumn.isVirtual() && metadataColumn.getMetadataKey().isPresent();
    }

    private static boolean isDefaultVirtualMetadataColumn(Column column) {
        if (!(column instanceof Column.MetadataColumn)) {
            return false;
        }
        Column.MetadataColumn metadataColumn = (Column.MetadataColumn)column;
        return metadataColumn.isVirtual() && !metadataColumn.getMetadataKey().isPresent();
    }

    private static class FieldReference {
        final Column column;
        final int inputIdx;
        final int columnIdx;

        FieldReference(Column column, int inputIdx, int columnIdx) {
            this.column = column;
            this.inputIdx = inputIdx;
            this.columnIdx = columnIdx;
        }

        FieldReferenceExpression toExpr() {
            return new FieldReferenceExpression(this.column.getName(), this.column.getDataType(), this.inputIdx, this.columnIdx);
        }
    }
}

