/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class ContextResolvedModel {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private final ObjectIdentifier objectIdentifier;
    @Nullable
    private final Catalog catalog;
    private final ResolvedCatalogModel resolvedModel;
    private final boolean anonymous;

    public static ContextResolvedModel permanent(ObjectIdentifier identifier, Catalog catalog, ResolvedCatalogModel resolvedModel) {
        return new ContextResolvedModel(identifier, Preconditions.checkNotNull(catalog), resolvedModel, false);
    }

    public static ContextResolvedModel temporary(ObjectIdentifier identifier, ResolvedCatalogModel resolvedModel) {
        return new ContextResolvedModel(identifier, null, resolvedModel, false);
    }

    public static ContextResolvedModel anonymous(ResolvedCatalogModel resolvedModel) {
        return ContextResolvedModel.anonymous(null, resolvedModel);
    }

    public static ContextResolvedModel anonymous(@Nullable String hint, ResolvedCatalogModel resolvedModel) {
        return new ContextResolvedModel(ObjectIdentifier.ofAnonymous(ContextResolvedModel.generateAnonymousStringIdentifier(hint, resolvedModel)), null, resolvedModel, true);
    }

    private ContextResolvedModel(ObjectIdentifier objectIdentifier, @Nullable Catalog catalog, ResolvedCatalogModel resolvedModel, boolean anonymous) {
        this.objectIdentifier = Preconditions.checkNotNull(objectIdentifier);
        this.catalog = catalog;
        this.resolvedModel = Preconditions.checkNotNull(resolvedModel);
        this.anonymous = anonymous;
    }

    public boolean isTemporary() {
        return this.catalog == null;
    }

    public boolean isPermanent() {
        return !this.isTemporary();
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public ObjectIdentifier getIdentifier() {
        return this.objectIdentifier;
    }

    public Optional<Catalog> getCatalog() {
        return Optional.ofNullable(this.catalog);
    }

    public ResolvedCatalogModel getResolvedModel() {
        return this.resolvedModel;
    }

    public CatalogModel getModel() {
        return this.resolvedModel.getOrigin();
    }

    public String toString() {
        return this.objectIdentifier.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextResolvedModel that = (ContextResolvedModel)o;
        return this.anonymous == that.anonymous && Objects.equals(this.objectIdentifier, that.objectIdentifier) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.resolvedModel, that.resolvedModel);
    }

    public int hashCode() {
        return Objects.hash(this.objectIdentifier, this.catalog, this.resolvedModel, this.anonymous);
    }

    private static String generateAnonymousStringIdentifier(@Nullable String hint, ResolvedCatalogModel resolvedModel) {
        if (hint == null) {
            try {
                hint = resolvedModel.getOptions().get(FactoryUtil.PROVIDER.key());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int id = uniqueId.incrementAndGet();
        if (hint == null) {
            return "*anonymous$" + id + "*";
        }
        return "*anonymous_" + hint + "$" + id + "*";
    }
}

