/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ModelChange;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.ModelAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.ModelNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.ProcedureNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public interface Catalog {
    default public Optional<Factory> getFactory() {
        return Optional.empty();
    }

    default public Optional<FunctionDefinitionFactory> getFunctionDefinitionFactory() {
        return Optional.empty();
    }

    public void open() throws CatalogException;

    public void close() throws CatalogException;

    @Nullable
    public String getDefaultDatabase() throws CatalogException;

    public List<String> listDatabases() throws CatalogException;

    public CatalogDatabase getDatabase(String var1) throws DatabaseNotExistException, CatalogException;

    public boolean databaseExists(String var1) throws CatalogException;

    public void createDatabase(String var1, CatalogDatabase var2, boolean var3) throws DatabaseAlreadyExistException, CatalogException;

    default public void dropDatabase(String name, boolean ignoreIfNotExists) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        this.dropDatabase(name, ignoreIfNotExists, false);
    }

    public void dropDatabase(String var1, boolean var2, boolean var3) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException;

    public void alterDatabase(String var1, CatalogDatabase var2, boolean var3) throws DatabaseNotExistException, CatalogException;

    public List<String> listTables(String var1) throws DatabaseNotExistException, CatalogException;

    public List<String> listViews(String var1) throws DatabaseNotExistException, CatalogException;

    default public List<String> listMaterializedTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("listMaterializedTables(String) is not implemented for %s.", this.getClass()));
    }

    public CatalogBaseTable getTable(ObjectPath var1) throws TableNotExistException, CatalogException;

    default public CatalogBaseTable getTable(ObjectPath tablePath, long timestamp) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("getTable(ObjectPath, long) is not implemented for %s.", this.getClass()));
    }

    public boolean tableExists(ObjectPath var1) throws CatalogException;

    public void dropTable(ObjectPath var1, boolean var2) throws TableNotExistException, CatalogException;

    public void renameTable(ObjectPath var1, String var2, boolean var3) throws TableNotExistException, TableAlreadyExistException, CatalogException;

    public void createTable(ObjectPath var1, CatalogBaseTable var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException;

    public void alterTable(ObjectPath var1, CatalogBaseTable var2, boolean var3) throws TableNotExistException, CatalogException;

    default public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.alterTable(tablePath, newTable, ignoreIfNotExists);
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath var1) throws TableNotExistException, TableNotPartitionedException, CatalogException;

    public List<CatalogPartitionSpec> listPartitions(ObjectPath var1, CatalogPartitionSpec var2) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException;

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath var1, List<Expression> var2) throws TableNotExistException, TableNotPartitionedException, CatalogException;

    public CatalogPartition getPartition(ObjectPath var1, CatalogPartitionSpec var2) throws PartitionNotExistException, CatalogException;

    public boolean partitionExists(ObjectPath var1, CatalogPartitionSpec var2) throws CatalogException;

    public void createPartition(ObjectPath var1, CatalogPartitionSpec var2, CatalogPartition var3, boolean var4) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException;

    public void dropPartition(ObjectPath var1, CatalogPartitionSpec var2, boolean var3) throws PartitionNotExistException, CatalogException;

    public void alterPartition(ObjectPath var1, CatalogPartitionSpec var2, CatalogPartition var3, boolean var4) throws PartitionNotExistException, CatalogException;

    public List<String> listFunctions(String var1) throws DatabaseNotExistException, CatalogException;

    default public List<String> listProcedures(String dbName) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("listProcedures is not implemented for %s.", this.getClass()));
    }

    public CatalogFunction getFunction(ObjectPath var1) throws FunctionNotExistException, CatalogException;

    default public Procedure getProcedure(ObjectPath procedurePath) throws ProcedureNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("getProcedure is not implemented for %s.", this.getClass()));
    }

    public boolean functionExists(ObjectPath var1) throws CatalogException;

    public void createFunction(ObjectPath var1, CatalogFunction var2, boolean var3) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException;

    public void alterFunction(ObjectPath var1, CatalogFunction var2, boolean var3) throws FunctionNotExistException, CatalogException;

    public void dropFunction(ObjectPath var1, boolean var2) throws FunctionNotExistException, CatalogException;

    public CatalogTableStatistics getTableStatistics(ObjectPath var1) throws TableNotExistException, CatalogException;

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath var1) throws TableNotExistException, CatalogException;

    public CatalogTableStatistics getPartitionStatistics(ObjectPath var1, CatalogPartitionSpec var2) throws PartitionNotExistException, CatalogException;

    default public List<CatalogTableStatistics> bulkGetPartitionStatistics(ObjectPath tablePath, List<CatalogPartitionSpec> partitionSpecs) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull(partitionSpecs, "partitionSpecs cannot be null");
        ArrayList<CatalogTableStatistics> result = new ArrayList<CatalogTableStatistics>(partitionSpecs.size());
        for (CatalogPartitionSpec partitionSpec : partitionSpecs) {
            result.add(this.getPartitionStatistics(tablePath, partitionSpec));
        }
        return result;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath var1, CatalogPartitionSpec var2) throws PartitionNotExistException, CatalogException;

    default public List<CatalogColumnStatistics> bulkGetPartitionColumnStatistics(ObjectPath tablePath, List<CatalogPartitionSpec> partitionSpecs) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull(partitionSpecs, "partitionSpecs cannot be null");
        ArrayList<CatalogColumnStatistics> result = new ArrayList<CatalogColumnStatistics>(partitionSpecs.size());
        for (CatalogPartitionSpec partitionSpec : partitionSpecs) {
            result.add(this.getPartitionColumnStatistics(tablePath, partitionSpec));
        }
        return result;
    }

    public void alterTableStatistics(ObjectPath var1, CatalogTableStatistics var2, boolean var3) throws TableNotExistException, CatalogException;

    public void alterTableColumnStatistics(ObjectPath var1, CatalogColumnStatistics var2, boolean var3) throws TableNotExistException, CatalogException, TablePartitionedException;

    public void alterPartitionStatistics(ObjectPath var1, CatalogPartitionSpec var2, CatalogTableStatistics var3, boolean var4) throws PartitionNotExistException, CatalogException;

    public void alterPartitionColumnStatistics(ObjectPath var1, CatalogPartitionSpec var2, CatalogColumnStatistics var3, boolean var4) throws PartitionNotExistException, CatalogException;

    default public List<String> listModels(String databaseName) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    default public CatalogModel getModel(ObjectPath modelPath) throws ModelNotExistException, CatalogException {
        throw new ModelNotExistException(null, modelPath);
    }

    default public boolean modelExists(ObjectPath modelPath) throws CatalogException {
        return false;
    }

    default public void dropModel(ObjectPath modelPath, boolean ignoreIfNotExists) throws ModelNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("dropModel(ObjectPath, boolean) is not implemented for %s.", this.getClass()));
    }

    default public void renameModel(ObjectPath modelPath, String newModelName, boolean ignoreIfNotExists) throws ModelNotExistException, ModelAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("renameModel(ObjectPath, String, boolean) is not implemented for %s.", this.getClass()));
    }

    default public void createModel(ObjectPath modelPath, CatalogModel model, boolean ignoreIfExists) throws ModelAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("createModel(ObjectPath, CatalogModel, boolean) is not implemented for %s.", this.getClass()));
    }

    default public void alterModel(ObjectPath modelPath, CatalogModel newModel, boolean ignoreIfNotExists) throws ModelNotExistException, CatalogException {
        throw new UnsupportedOperationException(String.format("alterModel(ObjectPath, CatalogModel, boolean) is not implemented for %s.", this.getClass()));
    }

    default public void alterModel(ObjectPath modelPath, CatalogModel newModel, List<ModelChange> modelChanges, boolean ignoreIfNotExists) throws ModelNotExistException, CatalogException {
        this.alterModel(modelPath, newModel, ignoreIfNotExists);
    }
}

