/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class FunctionDescriptor {
    private final String className;
    private final FunctionLanguage language;
    private final List<ResourceUri> resourceUris;
    private final Map<String, String> options;

    private FunctionDescriptor(String className, FunctionLanguage language, List<ResourceUri> resourceUris, Map<String, String> options) {
        this.className = className;
        this.language = language;
        this.resourceUris = resourceUris;
        this.options = options;
    }

    public static Builder forClassName(String className) {
        return new Builder(className);
    }

    public static Builder forFunctionClass(Class<? extends UserDefinedFunction> functionClass) {
        try {
            UserDefinedFunctionHelper.validateClass(functionClass);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Can not create a function '%s' due to implementation errors.", functionClass.getName()), t);
        }
        return new Builder(functionClass.getName()).language(FunctionLanguage.JAVA);
    }

    public String getClassName() {
        return this.className;
    }

    public FunctionLanguage getLanguage() {
        return this.language;
    }

    public List<ResourceUri> getResourceUris() {
        return this.resourceUris;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    @PublicEvolving
    public static final class Builder {
        private final String className;
        private FunctionLanguage language = FunctionLanguage.JAVA;
        private final List<ResourceUri> resourceUris = new ArrayList<ResourceUri>();
        private final Map<String, String> options = new HashMap<String, String>();

        private Builder(String className) {
            this.className = className;
        }

        public Builder language(FunctionLanguage language) {
            Preconditions.checkNotNull(language, "Function language must not be null.");
            this.language = language;
            return this;
        }

        public Builder resourceUris(List<ResourceUri> uri) {
            Preconditions.checkNotNull(uri, "Resource URIs must not be null.");
            this.resourceUris.addAll(uri);
            return this;
        }

        public Builder resourceUri(ResourceUri uri) {
            Preconditions.checkNotNull(uri, "Resource URI must not be null.");
            this.resourceUris.add(uri);
            return this;
        }

        public Builder option(String key, String value) {
            Preconditions.checkNotNull(key, "Option key must not be null.");
            Preconditions.checkNotNull(value, "Option value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public Builder options(Map<String, String> options) {
            Preconditions.checkNotNull(options, "Options must not be null.");
            this.options.putAll(options);
            return this;
        }

        public FunctionDescriptor build() {
            return new FunctionDescriptor(this.className, this.language, Collections.unmodifiableList(this.resourceUris), Collections.unmodifiableMap(this.options));
        }
    }
}

