/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermark.extension.eventtime;

import java.util.function.Consumer;
import org.apache.flink.api.common.watermark.BoolWatermark;
import org.apache.flink.api.common.watermark.LongWatermark;
import org.apache.flink.datastream.api.extension.eventtime.EventTimeExtension;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermark.WatermarkCombiner;
import org.apache.flink.streaming.runtime.watermarkstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;

public class EventTimeWatermarkCombiner
extends StatusWatermarkValve
implements WatermarkCombiner {
    private WrappedDataOutput<?> output = new WrappedDataOutput();

    public EventTimeWatermarkCombiner(int numInputChannels) {
        super(numInputChannels);
    }

    @Override
    public void combineWatermark(org.apache.flink.api.common.watermark.Watermark watermark, int channelIndex, Consumer<org.apache.flink.api.common.watermark.Watermark> watermarkEmitter) throws Exception {
        this.output.setWatermarkEmitter(watermarkEmitter);
        if (EventTimeExtension.isEventTimeWatermark((org.apache.flink.api.common.watermark.Watermark)watermark)) {
            this.inputWatermark(new Watermark(((LongWatermark)watermark).getValue()), channelIndex, this.output);
        } else if (EventTimeExtension.isIdleStatusWatermark((String)watermark.getIdentifier())) {
            this.inputWatermarkStatus(new WatermarkStatus(((BoolWatermark)watermark).getValue() ? -1 : 0), channelIndex, this.output);
        }
    }

    static class WrappedDataOutput<T>
    implements PushingAsyncDataInput.DataOutput<T> {
        private Consumer<org.apache.flink.api.common.watermark.Watermark> watermarkEmitter;

        public void setWatermarkEmitter(Consumer<org.apache.flink.api.common.watermark.Watermark> watermarkEmitter) {
            this.watermarkEmitter = watermarkEmitter;
        }

        @Override
        public void emitRecord(StreamRecord<T> streamRecord) throws Exception {
            throw new RuntimeException("Should not emit records with this output.");
        }

        @Override
        public void emitWatermark(Watermark watermark) throws Exception {
            this.watermarkEmitter.accept(EventTimeExtension.EVENT_TIME_WATERMARK_DECLARATION.newWatermark(watermark.getTimestamp()));
        }

        @Override
        public void emitWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
            this.watermarkEmitter.accept(EventTimeExtension.IDLE_STATUS_WATERMARK_DECLARATION.newWatermark(watermarkStatus.isIdle()));
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) throws Exception {
            throw new RuntimeException("Should not emit LatencyMarker with this output.");
        }

        @Override
        public void emitRecordAttributes(RecordAttributes recordAttributes) throws Exception {
            throw new RuntimeException("Should not emit RecordAttributes with this output.");
        }

        @Override
        public void emitWatermark(WatermarkEvent watermark) throws Exception {
            throw new RuntimeException("Should not emit WatermarkEvent with this output.");
        }
    }
}

